AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var A=require("workflow-designer/test-utilities");var D=require("workflow-designer/analytics");var G=require("workflow-designer/dialogs/delete-transition-dialog-view");var F=require("workflow-designer/workflow-model");var C=require("workflow-designer/io/ajax/workflow-global-transitions-ajax-manager");var E=require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");var B=require("jira/dialog/dialog");module("DeleteTransitionDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.deleteTransitionStub=this.sandbox.stub(E,"deleteTransition");this.deleteGlobalTransitionStub=this.sandbox.stub(C,"deleteGlobalTransition");this.workflowModel=new F({name:"Workflow Name"});this.sourceStatus=this.workflowModel.addStatus({stepId:1});this.transitionModel=this.workflowModel.addTransition({actionId:1,source:this.sourceStatus,target:this.workflowModel.addStatus({stepId:2})});this.globalTransitionModel=this.workflowModel.addTransition({actionId:1,globalTransition:true,source:this.sourceStatus,target:this.workflowModel.addStatus({stepId:2})});this.transitionModel.destroy=this.sandbox.spy();this.globalTransitionModel.destroy=this.sandbox.spy()},showDialog:function(){new G({workflowModel:this.workflowModel,transitionModel:this.transitionModel}).show();return B.current&&B.current.get$popup()},showGlobalTransitionDeleteDialog:function(){new G({workflowModel:this.workflowModel,transitionModel:this.globalTransitionModel}).show();return B.current&&B.current.get$popup()},teardown:function(){A.removeDialogs();this.sandbox.restore()}});test("Deleting a transition destroys transition model",function(){var H=jQuery.Deferred(),I=this.showDialog();ok(A.dialogIsVisible(),"The dialog is visible");ok(I.find(":submit").length,"The dialog has a submit button");this.deleteTransitionStub.returns(H.promise());this.sandbox.stub(D,"triggerRemoveTransition");A.submit(I);equal(I.find(":input:disabled").length,I.find(":input").length,"All inputs are disabled while submitting");equal(this.deleteTransitionStub.callCount,1,"WorkflowTransitionsAJAXManager.deleteTransition() was called");H.resolve();equal(this.transitionModel.destroy.callCount,1,"Transition model destroyed");ok(!A.dialogIsVisible(),"The dialog closed");ok(D.triggerRemoveTransition.calledOnce,"Analytics event for remove/transition has been triggered");sinon.assert.calledWith(D.triggerRemoveTransition,this.workflowModel.get("permissions"))});test("Deleting a global transition destroys transition model",function(){var I=jQuery.Deferred(),J=this.showGlobalTransitionDeleteDialog();ok(A.dialogIsVisible(),"The dialog is visible");ok(J.find(":submit").length,"The dialog has a submit button");this.deleteGlobalTransitionStub.returns(I.promise());this.sandbox.stub(D,"triggerRemoveGlobalTransition");A.submit(J);var H={transitionId:1,sourceStepId:1,workflowName:"Workflow Name"};equal(J.find(":input:disabled").length,J.find(":input").length,"All inputs are disabled while submitting");equal(this.deleteGlobalTransitionStub.callCount,1,"WorkflowGlobalTransitionsAJAXManager.deleteGlobalTransition() was called");deepEqual(this.deleteGlobalTransitionStub.args[0],[H],"It was passed the correct options");I.resolve();equal(this.globalTransitionModel.destroy.callCount,1,"Transition model destroyed");ok(!A.dialogIsVisible(),"The dialog closed");ok(D.triggerRemoveGlobalTransition.calledOnce,"Analytics event for remove/globaltransition has been triggered");sinon.assert.calledWith(D.triggerRemoveGlobalTransition,this.workflowModel.get("permissions"))});test("An error message is shown if deleting the transition fails",function(){var J=this.showDialog(),H,I="Oh noes!";this.deleteTransitionStub.returns(jQuery.Deferred().reject(I).promise());A.submit(J);H=J.find(".aui-message.error");equal(H.length,1,"An error message is shown in the dialog");ok(H.text().indexOf(I)>-1,"It contains the correct text");equal(J.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.deleteTransitionStub.returns(jQuery.Deferred().promise());A.submit(J);equal(J.find(".error").length,0,"Errors are removed on submit")});test("Closing the dialog doesn't destroy transition model",function(){var H=this.showDialog();ok(A.dialogIsVisible(),"The dialog is visible");H.find(".cancel").click();equal(this.transitionModel.destroy.callCount,0,"Transition model was not destroyed");ok(!A.dialogIsVisible(),"The dialog closed")});test("Can't delete initial transition",function(){this.sourceStatus.set("initial",true);var H=this.showDialog();ok(A.dialogIsVisible(),"The dialog is visible");ok(!H.find(":submit").length,"The dialog does not have a submit button")})});