define("workflow-designer/dialogs/delete-status-dialog-view", [
    "workflow-designer/dialogs/form-dialog-view",
    "workflow-designer/io/ajax/workflow-statuses-ajax-manager",
    "workflow-designer/analytics",
    "workflow-designer/templates",
    "workflow-designer/underscore",
    "jquery"
], function(
    FormDialogView,
    WorkflowStatusesAJAXManager,
    Analytics,
    Templates,
    _,
    jQuery
) {
    return FormDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.DeleteStatusDialogView# */
    {
        /**
         * DOM id used for the main element of this view
         *
         * @type {string}
         * @default
         */
        id: "delete-status-dialog",

        /**
         * Initialise the view.
         *
         * @constructs
         * @classdesc The workflow designer's "Delete Status" dialog.
         * @extends JIRA.WorkflowDesigner.Dialogs.FormDialogView
         * @param {object} options
         * @param {JIRA.WorkflowDesigner.StatusModel} options.statusModel The status model to destroy.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The application's <tt>WorkflowModel</tt>.
         */
        initialize: function (options) {
            _.bindAll(this, "_onError", "_onSuccess");

            this.statusModel = options.statusModel;
            this.workflowModel = options.workflowModel;
        },

        /**
         * @returns {jQuery} Content of the dialog
         * @private
         */
        _getContent: function () {
            var template = this._chooseContentTemplate();
            return jQuery(template(this.statusModel.toJSON()));
        },

        /**
         * @returns {function} Template used for the content
         * @private
         */
        _chooseContentTemplate: function () {
            var initialTransition = this.workflowModel.get("transitions").getInitial(),
                isInitial = this.statusModel.hasTransition(initialTransition);

            if (!this.workflowModel.statusIsDeletable(this.statusModel)) {
                return Templates.cannotDeleteStatusFromActiveWorkflow;
            }

            if (isInitial) {
                return Templates.cannotDeleteInitialStatus;
            }

            return Templates.confirmDeleteStatus;
        },

        /**
         * @param {jQuery.Event} e Submit event
         * @param {function} callback Function to call when this event has been handled
         * @private
         */
        _onSubmit: function (e, callback) {
            var options,
                request;

            e.preventDefault();
            this.disable();
            this.removeErrorMessages();

            options = {
                statusId: this.statusModel.get("statusId"),
                workflowName: this.workflowModel.get("name")
            };

            request = WorkflowStatusesAJAXManager.removeStatus(options);
            request.done(this._onSuccess).fail(callback).fail(this._onError);
        },

        /**
         * @param {Object} layoutData
         * @private
         */
        _onSuccess: function (layoutData) {
            Analytics.triggerRemoveStep(this.workflowModel.get('permissions'));
            this.hide();
            this.workflowModel.reset(layoutData);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Dialogs.DeleteStatusDialogView", null, require("workflow-designer/dialogs/delete-status-dialog-view"));