AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var B=require("workflow-designer/test-utilities");var F=require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");var H=require("workflow-designer/workflow-model");var E=require("workflow-designer/status-model");var A=require("workflow-designer/dialogs/delete-status-dialog-view");var D=require("workflow-designer/analytics");var C=require("jira/dialog/dialog");var G=require("jquery");module("DeleteStatusDialogView",{setup:function(){this.sandbox=sinon.sandbox.create();this.removeStatusStub=this.sandbox.stub(F,"removeStatus");this.workflowModel=new H({name:"Workflow Name",liveStepIds:[1]});this.statusModel=this.workflowModel.addStatus({stepId:1,statusId:100});this.transitionModel=this.workflowModel.addTransition({source:new E({stepId:2,statusId:101,initial:true}),target:this.statusModel});this.statusModel.destroy=this.sandbox.spy();this.workflowModel.destroy=this.sandbox.spy()},showDialog:function(){new A({workflowModel:this.workflowModel,statusModel:this.statusModel}).show();return C.current&&C.current.get$popup()},teardown:function(){B.removeDialogs();this.sandbox.restore()}});test("Deleting a status reloads the new workflow layout",function(){var J=this.showDialog(),K,L={},I=this.sandbox.stub(this.workflowModel,"reset");ok(B.dialogIsVisible(),"The dialog is visible");this.removeStatusStub.returns(G.Deferred().resolve(L).promise());this.sandbox.stub(D,"triggerRemoveStep");B.submit(J);K=[{statusId:100,workflowName:"Workflow Name"}];equal(this.removeStatusStub.callCount,1,"WorkflowStatusesAJAXManager.removeStatus() was called");deepEqual(this.removeStatusStub.args[0],K,"It was passed the correct arguments");ok(!B.dialogIsVisible(),"No dialog is visible");equal(I.callCount,1,"WorkflowModel.reset() was called");deepEqual(I.args[0],[L],"It was passed the layout data returned from removeStatus()");ok(D.triggerRemoveStep.calledOnce,"Analytics event for remove/step has been triggered");sinon.assert.calledWith(D.triggerRemoveStep,this.workflowModel.get("permissions"))});test("An error message is shown if deleting the status fails",function(){var K=this.showDialog(),I,J="Oh noes!";this.removeStatusStub.returns(G.Deferred().reject(J).promise());B.submit(K);I=K.find(".aui-message.error");equal(I.length,1,"An error message is shown in the dialog");ok(I.text().indexOf(J)>-1,"It contains the correct text");equal(K.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.removeStatusStub.returns(G.Deferred().promise());B.submit(K);equal(K.find(".error").length,0,"Errors are removed on submit")});test("Closing the dialog doesn't destroy workflow model",function(){var I=this.showDialog();ok(B.dialogIsVisible(),"The dialog is visible");I.find(".cancel").click();equal(this.workflowModel.destroy.callCount,0,"Workflow model was not destroyed");equal(this.statusModel.destroy.callCount,0,"Status model was not destroyed");ok(!B.dialogIsVisible(),"The dialog closed")});test("Can't delete initial status",function(){this.statusModel.set("initial",true);var I=this.showDialog();ok(B.dialogIsVisible(),"The dialog is visible");ok(!I.find(":submit").length,"The dialog does not have a submit button")});test("Can't delete status connected to the initial transition",function(){this.transitionModel.get("source").set("initial",true);var I=this.showDialog();ok(B.dialogIsVisible(),"The dialog is visible");ok(!I.find(":submit").length,"The dialog does not have a submit button")});test("Can't delete a non-deletable status",function(){this.statusModel=this.workflowModel.addStatus({stepId:1});this.workflowModel.statusIsDeletable=sinon.stub().returns(false);var I=this.showDialog();ok(B.dialogIsVisible(),"The dialog is visible");ok(!I.find(":submit").length,"The dialog does not have a submit button")});test("Can delete a deletable status",function(){this.statusModel=this.workflowModel.addStatus({stepId:1});this.workflowModel.statusIsDeletable=sinon.stub().returns(true);var I=this.showDialog();ok(B.dialogIsVisible(),"The dialog is visible");ok(I.find(":submit").length,"The dialog has a submit button")})});