AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var B=require("workflow-designer/browser-utilities");var A=require("workflow-designer/test-utilities");var C=require("workflow-designer/draw-2d");var D=require("jira/message");var F=require("workflow-designer/draw-2d-canvas/layer");var E=require("jquery");module("Draw2DCanvas",{setup:function(){this.canvas=A.testDraw2DCanvas();this.singleSelectionPolicy=new C.policy.canvas.SingleSelectionPolicy();this.canvas.installEditPolicy(this.singleSelectionPolicy);this.sandbox=sinon.sandbox.create();this.sandbox.stub(B,"getZoomLevel");this.sandbox.stub(D,"showErrorMsg").returns({css:E.noop,remove:E.noop})},teardown:function(){this.sandbox.restore()}});test("createLayers()",function(){var G;equal(this.canvas.getLayer("a"),undefined,"Layer a is undefined");this.canvas.createLayers("a");G=this.canvas.getLayer("a");ok(G instanceof F,"Layer a is defined");this.canvas.createLayers("a");ok(this.canvas.getLayer("a")===G,"Calling createLayers() is idempotent");equal(this.canvas.getLayer("b"),undefined,"Layer b is undefined");equal(this.canvas.getLayer("c"),undefined,"Layer c is undefined");this.canvas.createLayers("b","c");ok(this.canvas.getLayer("b") instanceof F,"Layer b is defined");ok(this.canvas.getLayer("c") instanceof F,"Layer c is defined")});test("Double clicks outside the canvas aren't observed",function(){var G=this.sandbox.stub(this.canvas,"onDoubleClick");this.canvas.fromDocumentToCanvasCoordinate=function(){return new C.geo.Point(0,0)};E(document).dblclick();equal(G.callCount,0,"The double click wasn't observed");this.canvas.html.dblclick();equal(G.callCount,1,"The double click was observed")});test("Dragging outside the container",function(){var H=sinon.spy(this.singleSelectionPolicy,"onMouseDown"),G=sinon.spy(this.singleSelectionPolicy,"onMouseDrag");this.canvas.html.trigger(E.Event("mousedown",{clientX:0,clientY:0,which:0}));equal(H.callCount,1,"The mouse down event was handled");E(document).trigger(E.Event("mousemove",{clientX:0,clientY:0}));equal(G.callCount,1,"The mouse move event was handled")});test("fitToContainer()",function(){var G=sinon.stub(this.canvas.paper,"setSize");this.canvas.html.css({height:100,width:100});this.canvas.svgElement.attr({height:100,width:100});this.canvas.fitToContainer();equal(G.callCount,0,"Does nothing if the elements are the same size");this.canvas.html.css("height",200).hide();this.canvas.fitToContainer();equal(G.callCount,0,"Does nothing if the SVG element isn't visible");this.canvas.html.show();this.canvas.fitToContainer();equal(G.callCount,1,"Paper#setSize() was called to resize the SVG element");deepEqual(G.args[0],[100,200],"It was passed the correct arguments");equal(this.canvas.svgElement.css("height"),"200px","The SVG element's CSS height is correct");equal(this.canvas.svgElement.css("width"),"100px","The SVG element's CSS width is correct")});test("getLayer()",function(){var G;G=this.canvas.getLayer("layer");equal(G,undefined,"getLayer() returns undefined for unknown layers");this.canvas.createLayers("layer");G=this.canvas.getLayer("layer");ok(G instanceof F,"getLayer() returns defined layers")});test("getSelectedFigure()",function(){var G=new C.shape.basic.Rectangle();this.canvas.addFigure(G);equal(this.canvas.getSelectedFigure(),null,"The selected figure is initially null");this.singleSelectionPolicy.select(this.canvas,G);ok(this.canvas.getSelectedFigure()===G,"getSelectedFigure() returns the selected figure")});test("removeFigure() removes the figure from its layer",function(){var G=new C.shape.basic.Rectangle(),H;this.canvas.createLayers("layer");H=this.canvas.getLayer("layer");H.addFigure(G);sinon.spy(H,"removeFigure");this.canvas.removeFigure(G);equal(H.removeFigure.callCount,1,"Layer#removeFigure() was called");ok(H.removeFigure.args[0][0]===G,"It was passed the correct figure")});test("Removing the currently hovered figure clears the currently hovered figure",function(){var G=new C.shape.basic.Rectangle();this.canvas.addFigure(G);this.canvas.currentHoverFigure=G;this.canvas.removeFigure(G);equal(this.canvas.currentHoverFigure,null,"The currently hovered figure was cleared")});test("selectFigure()",function(){var G=new C.shape.basic.Rectangle();this.canvas.addFigure(G);this.canvas.selectFigure(G);ok(this.canvas.getSelection().getPrimary()===G,"The figure was selected");this.canvas.selectFigure(null);equal(this.canvas.getSelection().getPrimary(),null,"The selection was cleared")})});