AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-loader","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var O=require("jquery");var H=require("aui/inline-dialog");var I=require("workflow-designer/draw-2d");var A=require("workflow-designer/transition-model");var D=require("workflow-designer/transition-view");var N=require("workflow-designer/draw-2d-canvas");var J=require("workflow-designer/draw-2d-canvas/layer-root-figure");var B=require("workflow-designer/status-model");var C=require("workflow-designer/initial-status-view");var M=require("workflow-designer/status-view");var E=require("workflow-designer/workflow-model");var K=require("workflow-designer/canvas-model");var G=require("workflow-designer/canvas-view");var F=require("workflow-designer/test-utilities");var L=require("workflow-designer/test-mocks");module("CanvasView",{setup:function(){this.sandbox=sinon.sandbox.create();this.workflowModel=new E();this.canvasModel=new K({},{workflowModel:this.workflowModel});this.canvasView=F.testCanvasView({canvasModel:this.canvasModel,workflowModel:this.workflowModel});this.canvas=this.canvasView.canvas},teardown:function(){F.removeDialogs();this.canvasView.remove();this.sandbox.restore()},triggerKeyDown:function(Q,P){P=_.extend({which:Q},P);O(document).trigger(O.Event("keydown",P))}});test("Adding a connection displays an AddTransitionDialogView",function(){var P=require("workflow-designer/dialogs/add-transition-dialog-view");var Q=new I.Connection();var U=A.prototype.initialize;var T;this.sandbox.stub(A.prototype,"initialize",function(){T=this;U.apply(this,arguments)});this.sandbox.spy(P.prototype,"initialize");this.sandbox.spy(P.prototype,"show");var S=this.workflowModel.addStatus();var R=this.workflowModel.addStatus();Q.setSource(this.canvasView.statusViews.at(0).getPorts()[0]);Q.setTarget(this.canvasView.statusViews.at(1).getPorts()[0]);sinon.spy(this.canvas,"removeFigure");this.canvasView.canvas.onNewConnection(Q);equal(P.prototype.initialize.callCount,1,"An AddTransitionDialogView was created");ok(P.prototype.initialize.args[0][0].canvasModel===this.canvasModel,"It was passed the correct canvas model");ok(P.prototype.initialize.args[0][0].transitionModel===T,"It was passed the correct transition model");ok(P.prototype.initialize.args[0][0].transitionModel.get("source").model===S.model,"It was passed the correct transition model");ok(P.prototype.initialize.args[0][0].transitionModel.get("target").model===R.model,"It was passed the correct transition model");ok(P.prototype.initialize.args[0][0].workflowModel===this.workflowModel,"It was passed the correct workflow model");equal(P.prototype.show.callCount,1,"It was shown");ok(this.canvas.removeFigure.calledWith(Q),"The connection was removed from the canvas");equal(this.workflowModel.get("transitions").length,0,"No TransitionModel was added to the WorkflowModel")});test("addStatus()",function(){var P=new B();this.sandbox.spy(C.prototype,"initialize");this.sandbox.spy(M.prototype,"initialize");this.canvasView.addStatus(P);equal(C.prototype.initialize.callCount,0,"No InitialStatusView was created for a normal status");equal(M.prototype.initialize.callCount,1,"A StatusView was created for a normal status");equal(M.prototype.initialize.args[0][0].model,P,"It is associated with the given model");P.set("initial",true);this.canvasView.addStatus(P);equal(C.prototype.initialize.callCount,1,"An InitialStatusView was created for an initial status");equal(C.prototype.initialize.args[0][0].model,P,"It is associated with the given model");equal(M.prototype.initialize.callCount,1,"No StatusView was created for an initial status")});test("addStatus() selects the new status if necessary",function(){var Q=this.sandbox.spy(M.prototype,"select"),P;P=new B();this.canvasView.addStatus(P);equal(Q.callCount,0,"The status wasn't selected");P=new B();this.canvasModel.set("selectedModel",P);this.canvasView.addStatus(P);equal(Q.callCount,1,"The status was selected")});test("addTransition()",function(){this.sandbox.spy(D.prototype,"initialize");var P=this.workflowModel.addStatus({});var Q;Q=this.workflowModel.addTransition({name:"Transition",source:P,target:P});this.canvasView.addTransition(Q);equal(D.prototype.initialize.callCount,1,"A new TransitionView was created");equal(D.prototype.initialize.args[0][0].model,Q,"It is associated with the given model");this.canvasView.addTransition(Q);equal(D.prototype.initialize.callCount,1,"Attempting to add duplicate transitions does nothing")});test("addTransition() selects the new transition if necessary",function(){var P=this.sandbox.spy(D.prototype,"select");var Q;Q=new A({source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});this.canvasView.addTransition(Q);equal(P.callCount,0,"The transition wasn't selected");Q=new A({source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});this.canvasModel.set("selectedModel",Q);this.canvasView.addTransition(Q);equal(P.callCount,1,"The transition was selected")});test("getCanvasBoundingBox() doesn't include LayerRootFigures",function(){var P;this.canvasView.canvas.getFigures=function(){return new I.util.ArrayList([new J(),L.figure([10,10,10,10])])};P=new I.geo.Rectangle(10,10,10,10);ok(P.equals(this.canvasView.getCanvasBoundingBox()),"The bounding box was calculated correctly")});test("getCanvasBoundingBox() includes relevant figures and lines",function(){var P;this.canvasView.canvas.getFigures=function(){return new I.util.ArrayList(_.map([[-10,-10,5,5],[0,0,5,5],[10,10,5,5]],L.figure))};this.canvasView.canvas.getLines=function(){return new I.util.ArrayList(_.map([[-8,-15,13,18],[-3,3,13,18],[-5,-8,23,13]],L.figure))};P=new I.geo.Rectangle(-10,-15,28,36);ok(P.equals(this.canvasView.getCanvasBoundingBox()),"The bounding box was calculated correctly")});test("WorkflowModel StatusCollection observation",function(){var Q=this.sandbox.spy(this.canvasView,"removeStatus");var P;this.sandbox.spy(M.prototype,"initialize");P=this.workflowModel.addStatus({});equal(M.prototype.initialize.callCount,1,"Adding a StatusModel causes a StatusView to be created");equal(M.prototype.initialize.args[0][0].model,P,"It is associated with the new StatusModel");this.workflowModel.reset({statuses:[],transitions:[]});ok(Q.callCount===1&&Q.args[0][0]===P,"Removing a StatusModel causes its StatusView to be removed")});test("WorkflowModel TransitionCollection observation",function(){this.sandbox.spy(D.prototype,"initialize");var R=this.sandbox.spy(this.canvasView,"removeTransition");var P;var Q;P=this.workflowModel.addStatus({});Q=this.workflowModel.addTransition({name:"Transition",source:P,target:P});equal(D.prototype.initialize.callCount,1,"Adding a TransitionModel causes a TransitionView to be created");equal(D.prototype.initialize.args[0][0].model,Q,"It is associated with the new TransitionModel");this.workflowModel.reset({statuses:[],transitions:[]});ok(R.callCount===1&&R.args[0][0]===Q,"Removing a TransitionModel causes its TransitionView to be removed")});test("Transition reconnection updates the TransitionModel if target status was not changed",function(){var P=this.workflowModel.addStatus({x:0,y:100}),V=this.canvasView.addStatus(P),S,Q=this.workflowModel.addStatus(),T=this.canvasView.addStatus(Q),U,R;U=this.workflowModel.addTransition({name:"Transition",source:Q,sourceAngle:90,target:P,targetAngle:-90});R=this.canvasView.addTransition(U);R._connection.setSource(T.getPortForAngle(0));R._connection.setTarget(V.getPortForAngle(0));R.trigger("reconnect",R);S={source:Q,sourceAngle:T.getAngleToPort(R._connection.getSource()),target:P,targetAngle:V.getAngleToPort(R._connection.getTarget())};deepEqual(_.pick(U.attributes,"source","sourceAngle","target","targetAngle"),S,"The TransitionModel's sourceAngle and targetAngle attributes were updated")});test("Transition reconnection shows EditTransitionTargetDialogView if target status was changed",function(){var W=require("workflow-designer/dialogs/edit-transition-target-dialog-view");this.sandbox.spy(W.prototype,"initialize");this.sandbox.stub(W.prototype,"show");var S=this.workflowModel.addStatus({x:0,y:100});var X;var R=this.workflowModel.addStatus();var P=this.canvasView.addStatus(R);var T=this.workflowModel.addStatus();var Q=this.canvasView.addStatus(T);var U;var V;U=this.workflowModel.addTransition({name:"Transition",source:R,sourceAngle:90,target:S,targetAngle:-90});V=this.canvasView.addTransition(U);V._connection.setSource(P.getPortForAngle(0));V._connection.setTarget(Q.getPortForAngle(0));V.trigger("reconnect",V);X={targetPort:Q.getPortForAngle(0),targetView:Q,transitionView:V,workflowModel:this.workflowModel};equal(W.prototype.initialize.callCount,1,"An EditTransitionTargetDialogView was created");ok(_.isEqual(W.prototype.initialize.args[0][0],X),"It was passed the correct arguments")});test("Transition reconnection shows EditTransitionSourceDialogView if source status was changed",function(){var T=require("workflow-designer/dialogs/edit-transition-source-dialog-view");this.sandbox.spy(T.prototype,"initialize");this.sandbox.stub(T.prototype,"show");var P=this.workflowModel.addStatus({x:0,y:100});var S;var Q=this.workflowModel.addStatus();var W=this.workflowModel.addStatus();var U=this.canvasView.addStatus(W);var V;var R;V=this.workflowModel.addTransition({name:"Transition",source:Q,sourceAngle:90,target:P,targetAngle:-90});R=this.canvasView.addTransition(V);R._connection.setSource(U.getPortForAngle(0));R.trigger("reconnect",R);S={newSourcePort:U.getPortForAngle(0),newSourceView:U,originalSourceStatus:Q,transitionView:R,workflowModel:this.workflowModel};equal(T.prototype.initialize.callCount,1,"An EditTransitionSourceDialogView was created");ok(_.isEqual(T.prototype.initialize.args[0][0],S),"It was passed the correct arguments")});test("Statuses without coordinates are positioned automatically",function(){var V=this.canvasView,T=sinon.spy(),Q=sinon.spy(),U=new B({id:"S<1>",x:10,y:10}),S=new B({id:"S<2>",x:200,y:200}),W=new B({id:"S<3>"}),R=new B({id:"S<4>"}),P=new A({name:"Transition",source:W,target:R});V.addTransition=function(){var X=G.prototype.addTransition.apply(V,arguments);X.resetConnection=Q;return X};this.workflowModel.on("layoutChanged",T);this.workflowModel.reset({statuses:[U,S,W,R],transitions:[P]});ok(_.isNumber(W.get("x")),"The first model has an x coordinate");ok(_.isNumber(W.get("y")),"The first model has a y coordinate");ok(_.isNumber(R.get("x")),"The second model has an x coordinate");ok(_.isNumber(R.get("y")),"The second model has a y coordinate");ok(T.called,"Triggered a layoutChanged event");ok(Q.called,"Transition between positioned statuses was reset")});test("Autocalculated transition ports must trigger autosaving",function(){var Q=sinon.spy(),R=new B({x:10,y:10}),S=new B({x:200,y:200}),P;P=new A({name:"Transition",source:R,target:S,ports:null});this.workflowModel.on("layoutChanged",Q);this.workflowModel.reset({statuses:[R,S],transitions:[P]});ok(Q.called,"Triggered a layoutChanged event")});test("Zooming with the mouse wheel hides the current inline dialog",function(){this.sandbox.stub(AJS,"InlineDialog");H.current={hide:sinon.spy()};sinon.stub(this.canvasView,"getCanvasBoundingBox").returns(new I.geo.Rectangle(0,0,0,0));this.canvasView._zoomHandler.trigger("zoom",{clientX:10,clientY:10,factor:1.05});equal(H.current.hide.callCount,1,"The current inline dialog was hidden")});test("The canvas is resized after its container is resized",function(){F.fakeTimer(function(R){var T=F.testCanvasView({model:this.workflowModel});var S=T.$el.width();var Q=T.$el.height();R.tick(150);equal(S,T.canvas.svgElement.width());equal(Q,T.canvas.svgElement.height());var P=function(){equal(T.$el.width(),T.canvas.svgElement.width());equal(T.$el.height(),T.canvas.svgElement.height())};T.$el.width(S*0.5);T.$el.height(Q*0.5);R.tick(150);P();T.$el.width(S);T.$el.height(Q);R.tick(150);P();T.remove()},this)});test("Deleting the selected transition",function(){var R,P=[O.ui.keyCode.BACKSPACE,O.ui.keyCode.DELETE],Q;this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});Q=this.canvasView.transitionViews.at(0);this.canvas.selectFigure(Q._connection);R=this.sandbox.stub(Q,"destroy");_.each(P,function(S){this.triggerKeyDown(S);equal(R.callCount,1,"TransitionView.destroy() was called for key code "+S);R.reset()},this)});test("Deleting the selected status",function(){var R,Q=[O.ui.keyCode.BACKSPACE,O.ui.keyCode.DELETE],P;this.workflowModel.addStatus({x:0,y:100});P=this.canvasView.statusViews.at(0);this.canvas.selectFigure(P._figure);R=this.sandbox.stub(P,"destroy");_.each(Q,function(S){this.triggerKeyDown(S);equal(R.callCount,1,"StatusView.destroy() was called for key code "+S);R.reset()},this)});test("Deletion is disabled when a dialog is visible",function(){var U,S=[O.ui.keyCode.BACKSPACE,O.ui.keyCode.DELETE],Q,P,R,T;O("#qunit-fixture").append('<div class="aui-blanket">');R=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});T=this.canvasView.addTransition(R).render();this.canvas.selectFigure(T._connection);U=this.sandbox.stub(T,"destroy");_.each(S,function(V){this.triggerKeyDown(V);equal(U.callCount,0,"TransitionView.destroy() was not called")},this);Q=this.workflowModel.addStatus({x:0,y:100});P=this.canvasView.addStatus(Q).render();P.select();U=this.sandbox.stub(P,"destroy");_.each(S,function(V){this.triggerKeyDown(V);equal(U.callCount,0,"StatusView.destroy() was not called")},this)});test("Deletion is disabled when the view is locked",function(){var P;this.canvasView.setLocked(true);this.workflowModel.addStatus({x:0,y:0});P=this.canvasView.statusViews.at(0);P.select();this.sandbox.stub(P,"destroy");this.triggerKeyDown(O.ui.keyCode.BACKSPACE);equal(P.destroy.callCount,0,"StatusView#destroy wasn't called")});test("Pressing delete key when target is an input does not display a DeleteTransitionDialogView",function(){var S,Q=[O.ui.keyCode.BACKSPACE,O.ui.keyCode.DELETE],P,R;P=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});R=this.canvasView.addTransition(P).render();this.canvas.selectFigure(R._connection);S=this.sandbox.stub(R,"destroy");_.each(Q,function(T){this.triggerKeyDown(T,{target:O("<input>")});equal(S.callCount,0,"TransitionView.destroy() was not called")},this)});test("Auto-fitting fits the SVG element to its container",function(){sinon.spy(this.canvasView.canvas,"fitToContainer");this.canvasView.autoFit();equal(this.canvasView.canvas.fitToContainer.callCount,1,"Canvas#fitToContainer() was called")});test("Auto-fitting centers the diagram if it fits into default bounds",function(){var P=sinon.spy(this.canvasView.canvas,"setViewBox");this.canvasView.$el.width(500);this.canvasView.$el.height(200);this.canvasView.canvas.getFigures=function(){return new I.util.ArrayList([L.figure([-10,-10,25,25])])};this.canvasView.autoFit();ok(P.args[0][0].equals(new I.geo.Rectangle(-247.5,-97.5,500,200)),"View box dimensions were not changed and the diagram was centered")});test("Auto-fitting scales and centers the diagram if it doesn't fit into default bounds",function(){var P=sinon.spy(this.canvasView.canvas,"setViewBox");this.canvasView.$el.width(500);this.canvasView.$el.height(200);sinon.stub(this.canvasView.canvas,"getViewBox").returns(new I.geo.Rectangle(-20,-20,620,350));this.canvasView.canvas.getFigures=function(){return new I.util.ArrayList([L.figure([-10,-10,600,300])])};this.canvasView.autoFit();ok(P.args[1][0].equals(new I.geo.Rectangle(-20,-35,620,350)),"View box was scaled and the diagram was centered")});test("Auto-fitting sets the CanvasModel's zoomLevel property",function(){this.canvasView.addStatus(new B());ok(!this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property isn't set");this.canvasView.autoFit();ok(this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property is set");equal(this.canvasModel.get("zoomLevel"),this.canvasView.canvas.getZoom(),"It is set to the canvas zoom level")});test("setResizeInterval()",function(){var P=this.sandbox.spy(N.prototype,"setResizeInterval");this.canvasView.setResizeInterval(42);equal(P.callCount,1,"Draw2DCanvas#setResizeInterval() was called");deepEqual(P.args[0],[42],"It was passed the correct arguments")});test("Selects views in response to the CanvasModel's selectedModel property changing",function(){var Q=this.sandbox.spy(M.prototype,"_onSelect"),P=this.workflowModel.addStatus({});this.canvasModel.set("selectedModel",P);equal(Q.callCount,1,"The view was selected")});test("Updates the CanvasModel in response to view (de)selection",function(){var Q=this.workflowModel.addStatus({}),P=this.canvasView.statusViews.at(0);P.select();ok(this.canvasModel.get("selectedModel")===Q,"The CanvasModel's selectedModel property was updated");ok(this.canvasModel.get("selectedView")===P,"The CanvasModel's selectedView property was updated");P.deselect();ok(!this.canvasModel.has("selectedModel"),"The CanvasModel's selectedModel property was cleared");ok(!this.canvasModel.has("selectedView"),"The CanvasModel's selectedView property was cleared")});test("Source view is updated when model source is updated",function(){var R,P,Q;P=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});Q=this.canvasView._getTransitionViewWithModel(P);this.sandbox.spy(Q,"resetConnection");R=this.workflowModel.addStatus({});P.set("source",R);ok(Q._getSourceView()===this.canvasView._getStatusViewWithModel(R),"Source view was updated");equal(Q.resetConnection.callCount,1,"Connection was reset")});test("Target view is updated when model target is updated",function(){var R,P,Q;P=this.workflowModel.addTransition({name:"Transition",source:this.workflowModel.addStatus({}),target:this.workflowModel.addStatus({})});Q=this.canvasView._getTransitionViewWithModel(P);this.sandbox.spy(Q,"resetConnection");R=this.workflowModel.addStatus({});P.set("target",R);ok(Q._getTargetView()===this.canvasView._getStatusViewWithModel(R),"Target view was updated");equal(Q.resetConnection.callCount,1,"Connection was reset")});test("Zooming sets the CanvasModel's zoomLevel property",function(){this.canvasView.addStatus(new B());ok(!this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property isn't set");this.canvasView.zoom(1);ok(this.canvasModel.has("zoomLevel"),"The CanvasModel's zoomLevel property is set");equal(this.canvasModel.get("zoomLevel"),this.canvasView.canvas.getZoom(),"It is set to the canvas zoom level")});test("When a transition is (de)selected, its siblings are (de)selected",function(){var T=this.workflowModel.addStatus({id:1}),S=this.workflowModel.addStatus({id:2}),R=this.workflowModel.addStatus({id:3}),P,X,Q,W,U,V;P=this.workflowModel.addTransition({actionId:"2",source:R,target:S});Q=this.workflowModel.addTransition({actionId:"1",source:R,target:T});U=this.workflowModel.addTransition({actionId:"1",source:S,target:T});X=this.canvasView._getTransitionViewWithModel(P);W=this.canvasView._getTransitionViewWithModel(Q);V=this.canvasView._getTransitionViewWithModel(U);this.sandbox.spy(X,"appearSelected");this.sandbox.spy(W,"appearSelected");V.trigger("selected",V);equal(X.appearSelected.callCount,0,"Non-sibling transitions aren't selected");equal(W.appearSelected.callCount,1,"Sibling transitions are selected");this.sandbox.spy(X,"unhighlight");this.sandbox.spy(W,"unhighlight");V.trigger("deselected",V);equal(X.unhighlight.callCount,0,"Non-sibling transitions aren't deselected");equal(W.unhighlight.callCount,1,"Sibling transitions are deselected")});test("validation is triggered when status or transition is added or removed",function(){var P=this.workflowModel.addStatus({});var Q=this.workflowModel.addTransition({actionId:"1",source:P,target:this.workflowModel.addStatus({})});equal(this.canvasView._validate.callCount,3,"validation was triggered three times after two statuses and one transition were added");this.canvasView._validate.reset();this.workflowModel.get("transitions").remove(Q);equal(this.canvasView._validate.callCount,1,"validation was triggered after transition was removed");this.canvasView._validate.reset();this.workflowModel.get("statuses").remove(P);equal(this.canvasView._validate.callCount,1,"validation was triggered after status was removed")})});