define("workflow-designer/canvas-view",["workflow-designer/looped-transition-container-view","workflow-designer/positioner","workflow-designer/dialogs/edit-transition-target-dialog-view","workflow-designer/dialogs/edit-transition-source-dialog-view","workflow-designer/dialogs/add-transition-dialog-view","workflow-designer/transition-model","workflow-designer/draw-2d-canvas/layer-root-figure","workflow-designer/policy/canvas/snap-to-geometry/guide-line-edit-policy","workflow-designer/policy/canvas/snap-to-geometry/snap-edit-policy","workflow-designer/policy/canvas/panning-single-selection-policy","workflow-designer/global-transition-view","workflow-designer/looped-transition-view","workflow-designer/transition-view","workflow-designer/status-view","workflow-designer/initial-status-view","workflow-designer/validator","workflow-designer/zoom-handler","workflow-designer/collection","workflow-designer/draw-2d-canvas","workflow-designer/draw-2d","aui/inline-dialog","workflow-designer/backbone","workflow-designer/underscore","jquery"],function(V,F,R,O,M,H,P,A,D,T,G,N,Q,I,B,K,U,X,J,S,E,C,W,L){return C.View.extend({className:"canvas",initialize:function(Z){W.bindAll(this,"_onKeyDown");Z=W.defaults({},Z,{immutable:false});this._canvasModel=Z.canvasModel;this.immutable=Z.immutable;this.statusViews=new X();this.transitionViews=new X();this._workflowModel=Z.workflowModel;this._zoomHandler=new U(this.el);this.immutable||L(document).on("keydown",this._onKeyDown);this.listenTo(this._canvasModel,"change:selectedModel",this._onSelectedModelChange);this.listenTo(this.statusViews,{deselected:this._clearSelectedView,"port:drag:end":this._onPortDragEnd,"port:drag:start":W.bind(this._setPortDragged,this,true),selected:this._setSelectedView});this.listenTo(this.transitionViews,{deselected:this._onTransitionDeselected,reconnect:this._onReconnect,selected:this._onTransitionSelected});this.listenTo(this._workflowModel,"reset:after",this._afterReset);this.listenTo(this._workflowModel.get("statuses"),{add:this.addStatus,remove:this.removeStatus,reset:this.resetStatuses});var Y=this;this.listenTo(this._workflowModel.get("transitions"),{add:this.addTransition,"change:source change:target":this._updateTransitionSourceAndTarget,"add remove change:target change: source change:description change:name change:transitionOptions":function(){Y._validate()},remove:this.removeTransition,reset:this.resetTransitions});this.listenTo(this._workflowModel.get("statuses"),{"add remove change:name change:description change:statusCategory":function(){Y._validate()}});this.listenTo(this._workflowModel,"loopedTransitionAdded",this._reloadLoopedTransitionContainerView);this.listenTo(this._workflowModel,"loopedTransitionRemoved",this._reloadLoopedTransitionContainerView);this.listenTo(this._zoomHandler,"zoom",this._onZoom)},_validate:function(){if(!this.immutable){K.validate(this._workflowModel)}},_afterReset:function(){this._positionNewStatuses();this._reloadLoopedTransitionContainerView();this._validate()},addStatus:function(Z){var c=Z.get("initial"),a=this._canvasModel.get("selectedModel")===Z,Y,b;if(c){b=B}else{b=I}Y=new b({canvas:this.canvas,getAllTargetPorts:W.bind(this._getAllTargetPorts,this),immutable:this.immutable,isPortDragged:W.bind(this._isPortDragged,this),model:Z,workflowModel:this._workflowModel}).render();this.statusViews.add(Y);a&&Y.select();return Y},addTransition:function(Y){var d=Y.isGlobalTransition(),c=Y.isLoopedTransition(),Z=this._canvasModel.get("selectedModel")===Y,a=this._getTransitionViewWithModel(Y),b;if(a){return a}if(c){b=N}else{if(d){b=G}else{b=Q}}a=new b({canvas:this.canvas,canvasModel:this._canvasModel,immutable:this.immutable,model:Y,sourceView:this._getStatusViewWithModel(Y.get("source")),targetView:this._getStatusViewWithModel(Y.get("target")),workflowModel:this._workflowModel});a.requestResponse&&a.requestResponse.setHandler("isSelected",this._transitionIsSelected,this);a.render();this.transitionViews.add(a);Z&&a.select();return a},autoFit:function(){var Y,b,Z,a=10,c;this.canvas.fitToContainer();Y=this.getCanvasBoundingBox();if(Y){Y.scale(a*2,a*2);c=new S.geo.Rectangle(0,0,this.$el.width(),this.$el.height());Z=Y.getHeight()<=c.getHeight()&&Y.getWidth()<=c.getWidth();if(!Z){this.canvas.setViewBox(Y);c=this.canvas.getViewBox()}b=Y.getCenter();this.canvas.setViewBox(new S.geo.Rectangle(b.getX()-c.getWidth()/2,b.getY()-c.getHeight()/2,c.getWidth(),c.getHeight()));this._canvasModel.set("zoomLevel",this.canvas.getZoom())}},_clearSelectedView:function(Y){var Z=this._canvasModel.get("selectedView")===Y;Z&&this._canvasModel.selectView(null)},_createCanvas:function(Y){var Z,a=W.bind(this.getCanvasBoundingBox,this),c=this._getUniqueId(),b;Y=L(Y);Y.append(this.el);this.$el.attr("id",c);b=["statuses","selected-status","transitions","global-transitions","looped-transitions-container","looped-transitions","highlighted-transition","selected-transition","transition-labels"];Z=new J(c);Z.createLayers(b);Z.installEditPolicy(new T(a));Z.installEditPolicy(new D());Z.installEditPolicy(new A());Z.onNewConnection=W.bind(this._onNewConnection,this);return Z},_delete:function(){var Y=this._canvasModel.get("selectedView");Y&&Y.destroy();return !!Y},_getAllTargetPorts:function(){function Z(a){return a.model.isInitial()}function Y(a){return a.getPorts()}return this.statusViews.chain().reject(Z).flatMap(Y).value()},getCanvasBoundingBox:function(){var Z,b=this.canvas.getFigures().asArray(),Y=this.canvas.getLines().asArray();function a(d){var e=d.getBoundingBox();if(Z){Z=Z.union(e)}else{Z=e}}function c(d){return d instanceof P}W.chain(b).reject(c).each(a);W.each(Y,a);return Z},_getLoopedTransitionViews:function(){var Y=this.transitionViews.chain().filter(function(Z){return Z.model.isLoopedTransition()}).sortBy(function(Z){return Z.model.getActionId()}).value();return new X(Y)},_getSiblingTransitions:function(Y){var a=Y.model.get("actionId");function Z(b){return b.model.get("actionId")===a}return this.transitionViews.chain().filter(Z).without(Y).value()},_getStatusViewWithModel:function(Y){return this.statusViews.find(function(Z){return Z.model===Y})},getStatusViewWithPort:function(Y){return this.statusViews.find(function(Z){return W.contains(Z.getPorts(),Y)})},_getTransitionViewWithModel:function(Y){return this.transitionViews.find(function(Z){return Z.model===Y})},_getUniqueId:function(){var Y=0,Z;do{Y++;Z="workflow-designer"+Y}while(L("#"+Z).length);return Z},_isPortDragged:function(){return !!this.portDragged},_onKeyDown:function(Y){if(this._shouldHandleDelete(Y)){this._delete()&&Y.preventDefault()}},_onNewConnection:function(a){var Z=a.getSource(),Y=this.getStatusViewWithPort(Z),c=a.getTarget(),b=this.getStatusViewWithPort(c),d;d=new H({source:Y.model,sourceAngle:Y.getAngleToPort(Z),target:b.model,targetAngle:b.getAngleToPort(c)});this.canvas.removeFigure(a);new M({canvasModel:this._canvasModel,transitionModel:d,workflowModel:this._workflowModel}).show()},_onReconnect:function(c){var e,Z=c.getConnection().getSource(),Y=this.getStatusViewWithPort(Z),d,b=c.getConnection().getTarget(),a=this.getStatusViewWithPort(b);e=Y.model!==c.model.get("source");d=a.model!==c.model.get("target");if(e){new O({newSourcePort:Z,newSourceView:Y,originalSourceStatus:c.model.get("source"),transitionView:c,workflowModel:this._workflowModel}).show()}else{if(d){new R({targetPort:b,targetView:a,transitionView:c,workflowModel:this._workflowModel}).show()}else{c.model.set({source:Y.model,sourceAngle:Y.getAngleToPort(Z),target:a.model,targetAngle:a.getAngleToPort(b)})}}},_onTransitionDeselected:function(Y){this._clearSelectedView(Y);W.invoke(this._getSiblingTransitions(Y),"unhighlight")},_onTransitionSelected:function(Y){this._setSelectedView(Y);W.invoke(this._getSiblingTransitions(Y),"appearSelected")},_onZoom:function(Y){E.current&&E.current.hide();this.zoom(Y.factor,this.canvas.fromDocumentToCanvasCoordinate(Y.clientX,Y.clientY))},_positionNewStatuses:function(){var Z,a=this._workflowModel.get("statuses").map(this._getStatusViewWithModel,this);Z=F.positionStatuses({statusViews:a,viewBox:this.canvas.getViewBox(),workflowModel:this._workflowModel});function Y(b){return !b.model.isGlobalTransition()&&b.isConnectedToAnyStatus(Z)}this.transitionViews.chain().filter(Y).invoke("resetConnection")},_reloadLoopedTransitionContainerView:function(){var Z=this._workflowModel.get("loopedTransitionContainer"),Y;if(Z){Y=this._getLoopedTransitionViews();if(this._loopedTransitionContainerView){if(Y.length){this._loopedTransitionContainerView.reset(Y)}else{this._loopedTransitionContainerView.remove();this._loopedTransitionContainerView=null;this._workflowModel.removeLoopedTransitionContainer()}}else{this._loopedTransitionContainerView=new V({canvas:this.canvas,immutable:this.immutable,model:Z,transitionViews:Y,workflowModel:this._workflowModel}).render();F.positionLoopedTransitionContainer({loopedTransitionContainerView:this._loopedTransitionContainerView,statusViews:this.statusViews})}}},remove:function(){C.View.prototype.remove.apply(this,arguments);L(document).off("keydown",this._onKeyDown);this._zoomHandler.destroy();this.canvas&&this.canvas.remove()},removeStatus:function(Z){var Y=this._getStatusViewWithModel(Z);if(Y){Y.remove();this.statusViews.remove(Y)}},removeTransition:function(Y){var Z=this._getTransitionViewWithModel(Y);if(Z){Z.remove();this.transitionViews.remove(Z)}},render:function(Y){this.canvas||(this.canvas=this._createCanvas(Y));return this},resetStatuses:function(){while(this.statusViews.length){this.removeStatus(this.statusViews.at(0).model)}this._workflowModel.get("statuses").each(function(Y){this.addStatus(Y)},this)},resetTransitions:function(){while(this.transitionViews.length){this.removeTransition(this.transitionViews.at(0).model)}this._workflowModel.get("transitions").forEach(function(Y){this.addTransition(Y)},this)},_transitionIsSelected:function(a){var c=a.model.get("actionId"),Z=this._canvasModel.get("selectedView")===a,Y=this._canvasModel.get("selectedModel"),b=!!Y&&Y.get("actionId")===c;return Z||b},_onSelectedModelChange:function(b,Y){var a=this._getStatusViewWithModel(Y)||this._getTransitionViewWithModel(Y),Z=this._canvasModel.get("selectedView");if(Y&&a&&a!==Z){a.select()}},_onPortDragEnd:function(){function Y(Z){return Z.model.isInitial()}this._setPortDragged(false);this.statusViews.chain().reject(Y).invoke("updatePortsVisibility")},setLocked:function(Y){this._isLocked=Y},_setPortDragged:function(Y){this.portDragged=Y},setResizeInterval:function(Y){this.canvas.setResizeInterval(Y)},_setSelectedView:function(Y){this._canvasModel.selectView(Y)},_shouldHandleDelete:function(b){var Y=[L.ui.keyCode.BACKSPACE,L.ui.keyCode.DELETE],c=!!L(".aui-blanket:visible").length,a=W.contains(Y,b.which),Z=L(b.target).is(":input");return !c&&a&&!Z&&!this._isLocked},_updateTransitionSourceAndTarget:function(Z){var Y=this._getStatusViewWithModel(Z.get("source")),a=this._getStatusViewWithModel(Z.get("target")),b=this._getTransitionViewWithModel(Z);b.setViews(Y,a);b.resetConnection()},zoom:function(Y,Z){this.canvas.zoom(Y,Z||this.canvas.getViewBox().getCenter(),this.getCanvasBoundingBox());this._canvasModel.set("zoomLevel",this.canvas.getZoom())}})});AJS.namespace("JIRA.WorkflowDesigner.CanvasView",null,require("workflow-designer/canvas-view"));