AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var C;var D=require("workflow-designer/workflow-model");var B=require("workflow-designer/canvas-model");var A=require("workflow-designer/test-utilities");var E=require("workflow-designer/backbone");module("ActionsView",{createView:function(G){var F;C=this.context.require("workflow-designer/actions-view");F=new C(_.extend({canvasModel:this.canvasModel,fullScreenButton:true,workflowModel:this.workflowModel},G));this.container.empty().append(F.render().el);return F},mockUser:function(){this.context.mock("jira/util/users/logged-in-user",{username:this.sandbox.stub().returns("bob")})},setup:function(){this.context=AJS.test.mockableModuleContext();this.context.mock("workflow-designer/status-model",require("workflow-designer/status-model"));this.container=jQuery("#qunit-fixture");this.sandbox=sinon.sandbox.create();this.workflowModel=new D();this.canvasModel=new B({},{workflowModel:this.workflowModel})},teardown:function(){A.removeDialogs();this.sandbox.restore()}});test("Add Status",function(){var F,H=_.extend({hide:sinon.stub(),show:sinon.stub()},E.Events),G=this.sandbox.stub().returns(H);this.context.mock("workflow-designer/dialogs/add-status-inline-dialog-view",G);this.createView();F=this.container.find(".add-status");F.click();equal(G.callCount,1,"An AddStatusInlineDialogView was created");ok(G.args[0][0].trigger[0]===this.container.find(".add-status")[0],"Its constructor was passed the correct arguments");equal(H.show.callCount,1,"The dialog was shown");F.addClass("active").click();equal(H.hide.callCount,1,"The dialog was hidden")});test("Add transition",function(){var H={show:sinon.spy()},G=this.sandbox.stub().returns(H),I;this.context.mock("workflow-designer/dialogs/add-transition-dialog-view",G);var F=this.createView();F.$(".add-transition").click();equal(G.callCount,1,"An AddTransitionDialogView was created");ok(G.args[0][0].workflowModel===this.workflowModel,"Its constructor was passed the correct arguments");equal(H.show.callCount,1,"The dialog was shown");I=G.args[0][0].transitionModel;ok(!I.has("source"),"The transition doesn't have a source set");ok(!I.has("target"),"The transition doesn't have a target set")});test("Add transition with a status selected",function(){var F=this.sandbox.spy(require("workflow-designer/dialogs/add-transition-dialog-view"));this.context.mock("workflow-designer/dialogs/add-transition-dialog-view",F);var H=this.workflowModel.addStatus();var G=this.createView();var I;this.canvasModel.set("selectedModel",H);G.$(".add-transition").click();I=F.args[0][0].transitionModel;ok(I.get("source")===H,"The transition's source is the selected status");ok(I.get("target")===H,"The transition's target is the selected status")});test("Contains editing buttons in mutable mode",function(){this.createView();equal(this.container.find(".aui-toolbar2-primary").length,1,"Editing buttons are present")});test("Doesn't contain editing buttons in immutable mode",function(){this.createView({immutable:true});equal(this.container.find(".aui-toolbar2-primary").length,0,"Editing buttons are not present")});test("Entering and exiting full screen mode",function(){var G=this.createView(),I=this.container.find(".enter-full-screen"),K=I.tipsy(true),F=this.container.find(".exit-full-screen"),J=F.tipsy(true),H=sinon.spy(),L=sinon.spy();G.on("fullScreen:enter",H);G.on("fullScreen:exit",L);ok(!I.hasClass("hidden"),"Enter full screen button is visible initially");ok(K.enabled,"Enter full screen button tooltip is enabled");ok(F.hasClass("hidden"),"Exit full screen button is hidden initially");ok(!J.enabled,"Exit full screen button tooltip is disabled");I.click();ok(I.hasClass("hidden"),"Enter full screen button is hidden after entering full screen");ok(!K.enabled,"Enter full screen button tooltip is disabled");ok(!F.hasClass("hidden"),"Exit full screen button is visible after entering full screen");ok(J.enabled,"Exit full screen button tooltip is enabled");ok(H.calledOnce,"fullScreen:enter event triggered upon entering full screen");F.click();ok(!I.hasClass("hidden"),"Enter full screen button is visible after exiting full screen");ok(K.enabled,"Enter full screen button tooltip is enabled");ok(F.hasClass("hidden"),"Exit full screen button is hidden after exiting full screen");ok(!J.enabled,"Exit full screen button tooltip is disabled");ok(L.calledOnce,"fullScreen:exit event triggered upon exiting full screen")});test("Events are forwarded from the AddStatusInlineDialogView",function(){var H=_.extend({show:jQuery.noop},E.Events),G=sinon.spy(),F=sinon.spy();this.context.mock("workflow-designer/dialogs/add-status-inline-dialog-view",this.sandbox.stub().returns(H));this.createView().on({"addStatus:done":G,"addStatus:submit":F});this.container.find(".add-status").click();H.trigger("submit");equal(F.callCount,1,"An addStatus:submit event was triggered");H.trigger("done");equal(G.callCount,1,"An addStatus:done event was triggered")});test("Full screen mode can be disabled",function(){this.createView({fullScreenButton:false});equal(this.container.find(".full-screen-trigger").length,0,"No full screen triggers are present")});test('Toggling the "Show Transition Labels" checkbox updates CanvasModel',function(){var F;this.canvasModel.set("showTransitionLabels",false);this.createView();F=this.container.find("#show-transition-labels");ok(!F.is(":checked"),"Checkbox is rendered unchecked when the model attribute is false");this.canvasModel.set("showTransitionLabels",true);this.createView();F=this.container.find("#show-transition-labels");ok(F.is(":checked"),"Checkbox is rendered checked when the model attribute is true");F.attr("checked",true).trigger("change");ok(this.canvasModel.get("showTransitionLabels"),"The model property is true when checkbox is checked");F.attr("checked",false).trigger("change");ok(!this.canvasModel.get("showTransitionLabels"),"The model property is false when checkbox is not checked")});test("Last edited message not displayed when immutable",function(){var F;this.createView({immutable:true});this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());F=this.container.find(".last-edited-message");ok(!F.length,"Last edited message should not be displayed.")});test("Last edited message displayed when both updateAuthor and updatedDate defined",function(){var F;this.mockUser();this.createView();this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());F=this.container.find(".last-edited-message");equal(F.text(),"workflow.designer.last.edited.by.you","Last edited message should be displayed.")});test("Last edited message not displayed when lastUpdater defined and updatedDate not defined",function(){var F;this.mockUser();this.createView();this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});F=this.container.find(".last-edited-message");ok(!F.length,"Last edited message should not be displayed.")});test("Last edited message not displayed when updateAuthor not defined and updatedDate defined",function(){var F;this.mockUser();this.createView();this.workflowModel.set("updatedDate",new Date());F=this.container.find(".last-edited-message");ok(!F.length,"Last edited message should not be displayed.")});test("Last edited message not displayed when both updateAuthor and updatedDate not defined",function(){var F;this.mockUser();this.createView();F=this.container.find(".last-edited-message");ok(!F.length,"Last edited message should not be displayed.")});test("'You' last edited message should be displayed if current user is same as last updater",function(){var F;this.mockUser();this.createView();this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date());F=this.container.find(".last-edited-message");equal(F.text(),"workflow.designer.last.edited.by.you","Last edited message should be displayed.")});test("'User' last edited message should be displayed if current user is not same as last updater",function(){this.sandbox.stub(AJS,"format");this.mockUser();this.createView();this.workflowModel.set("updateAuthor",{userName:"jim",displayName:"Jim Dude"});this.workflowModel.set("updatedDate",new Date());sinon.assert.calledWith(AJS.format,"workflow.designer.last.edited.by.other.user","Jim Dude")});test("Last edited message not updated when model updated",function(){this.mockUser();this.createView();this.workflowModel.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.workflowModel.set("updatedDate",new Date(new Date().getTime()));equal(this.container.find(".last-edited-message").text(),"workflow.designer.last.edited.by.you","Last edited message should be displayed.");this.workflowModel.set("updateAuthor",{userName:"jim",displayName:"Jim Man"});equal(this.container.find(".last-edited-message").text(),"workflow.designer.last.edited.by.you","Last edited message should still be the same as before.")});test("The add status inline dialog is recreated on render",function(){var H=_.extend({remove:sinon.stub(),show:sinon.stub()},E.Events),G=this.sandbox.stub().returns(H);this.context.mock("workflow-designer/dialogs/add-status-inline-dialog-view",G);var F=this.createView();F.$(".add-status").click();F.render();equal(H.remove.callCount,1,"The AddStatusInlineDialogView was removed");F.$(".add-status").click();equal(G.callCount,2,"A new AddStatusInlineDialogView was created")})});