define("workflow-designer/triangle-figure-upwards", [
    "workflow-designer/draw-2d",
    "workflow-designer/underscore"
], function(
    draw2d,
    _
) {
    /**
     * @classdesc Renders a simple, left pointing, triangle figure
     * @class JIRA.WorkflowDesigner.TriangleFigure
     * @extends draw2d.VectorFigure
     */
    return draw2d.VectorFigure.extend(
    /** @lends JIRA.WorkflowDesigner.TriangleFigureUpwards#*/
    {
        /**
         * Repaints the figure
         *
         * @param {object} attributes
         */
        repaint: function(attributes) {
            var path;

            if (this.shape === null) {
                return;
            }

            path = [
                "M", this.getAbsoluteX(), this.getAbsoluteY() + this.getHeight() / 2, // start at the center left
                "l", this.getWidth() / 1.5, -(this.getHeight() / 1.5),
                "l", this.getWidth() / 1.5, (this.getHeight() / 1.5), //
                "Z"
            ].join(" ");

            this._super(_.extend({}, attributes, {
                path: path
            }));
        },

        /**
         * @returns {string} Path in SVG format
         */
        createShapeElement: function() {
            return this.canvas.paper.path("");
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.TriangleFigureUpwards", null, require("workflow-designer/triangle-figure-upwards"));