AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var TriangleFigure = require("workflow-designer/triangle-figure");
    var TestUtilities = require("workflow-designer/test-utilities");

    module("TriangleFigure", {

        assertPathData: function (figure, expected) {
            var path = figure.getShapeElement()[0].attributes.d;
            var pathData = path.value;
            equal(pathData, expected,
                "The figure's SVG path data was correct");
        },

        setup: function () {
            this.canvas = TestUtilities.testCanvasView().canvas;
        }
    });

    test("A TriangleFigure is created with the correct path", function () {
        var triangle = new TriangleFigure();

        triangle.setDimension(100, 100);

        this.canvas.addFigure(triangle);

        this.assertPathData(triangle, [
            "M0,50",
            "L100,0",
            "L100,100",
            "Z"
        ].join(""));
    });

});
