AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var TestUtilities = require("workflow-designer/test-utilities");
    var WorkflowModel = require("workflow-designer/workflow-model");
    var StatusPort = require("workflow-designer/status-port");
    var StatusView = require("workflow-designer/status-view");
    var draw2d = require("workflow-designer/draw-2d");
    var _ = require("workflow-designer/underscore");

    module("StatusPort", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.canvasView = TestUtilities.testCanvasView();
            this.canvas = this.canvasView.canvas;
            this.workflowModel = new WorkflowModel();

            this.statusPort = new StatusPort({
                canvas: this.canvas,
                getAllTargetPorts: function () {
                    return [];
                }
            });
            this.statusPort.parent = new draw2d.Figure();
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Starting a status port drag triggers select event", function () {
        var selectSpy = this.sandbox.spy();
        this.statusPort.bind("select", selectSpy);
        this.statusPort.onDragStart();
        equal(selectSpy.calledOnce, 1, "Select handler should have been called once.");
    });

    test("getDropTarget() detects the target port", function () {
        var statusView, tests;

        statusView = new StatusView({
            canvas: this.canvas,
            isPortDragged: function () {
                return true;
            },
            model: this.workflowModel.addStatus({id: "status", x: 0, y: 0}),
            workflowModel: this.workflowModel,
            getAllTargetPorts: function () {
                return statusView.getPorts();
            }
        }).render();

        // For reference, these are the ports of the status:
        // Port #0  top-left     12,  0
        // Port #1  top          29,  0
        // Port #2  top-right    45,  0
        // Port #3  right        58, 14
        // Port #4  bottom-right 45, 28
        // Port #5  bottom       29, 28
        // Port #6  bottom-left  12, 28
        // Port #7  bottom-left   0, 14
        //
        // Note: if you do the math, you will notice the numbers used in the tests are weird.
        // That's because draw2D hitTest for Port misinterpret the corona's width and uses it
        // as corona's radius. We decided to not fix it because the drag and drop interaction
        // actually feels better.
        tests = [
            [[29, 0], 1, "Inside another port"],
            [[66, 24], 3, "Inside the corona of another port"],
            [[75, 14], 3, "Just in the limits of the corona"],
            [[77, 14], null, "Just outside the corona"],
            [[38, 0], 1, "Between two ports, a bit closer to the left one"],
            [[39, 0], 2, "Between two ports, a bit closer to the right one"]
        ];

        _.each(tests, function (test) {
            var actualPort,
                draggedPort = statusView.getPorts()[0],
                expectedPort = test[1] && statusView.getPorts()[test[1]];

            actualPort = draggedPort.getDropTarget(test[0][0], test[0][1]);

            ok(actualPort === expectedPort, test[2]);
        });
    });

});

