define("workflow-designer/project-admin-workflows", [
    "workflow-designer/dialog",
    "workflow-designer/templates",
    "jquery"
], function(
    Dialog,
    Templates,
    jQuery
) {
    /**
     * Dialog
     *
     * @inner
     * @type {JIRA.WorkflowDesigner.Dialog}
     */
    var workflowDialog;

    /**
     * Code related to showing the new workflow designer on the project admin workflow pages.
     *
     * @namespace
     */
    return {
        /**
         * Adds the new workflow designer to the project admin workflow page.
         * This gets appended in after the 'view as text' link.
         *
         * @param textModeLink The link to append the new link after.
         */
        replaceLink: function (existingLink, textModeLink) {
            var workflowName = textModeLink.data('workflowname');
            var diagramLink = this._addDiagramLink(existingLink, workflowName);
            diagramLink.click(function(e) {
                e.preventDefault();

                workflowDialog = new Dialog({
                    id: "view-workflow-dialog-project-admin",
                    workflowId: function() {
                        return workflowName;
                    }
                });
                workflowDialog.show();
            });
        },

        /**
         * Add a "diagram" workflow mode link.
         *
         * @param existingLink The existing diagram mode link.
         * @param workflowName the workflow name to link to.
         * @return {jQuery} The new link.
         */
        _addDiagramLink: function (existingLink, workflowName) {
            var diagramLink = jQuery(Templates.ProjectAdminWorkflows.link({workflowName: workflowName}));
            existingLink.replaceWith(diagramLink);
            return diagramLink;
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.ProjectAdminWorkflows", null, require("workflow-designer/project-admin-workflows"));


(function () {
    var ProjectAdminWorkflows = require("workflow-designer/project-admin-workflows");
    var BrowserSupport = require("workflow-designer/browser-support");
    var Events = require('jira/util/events');
    var Types = require('jira/util/events/types');
    var Reasons = require('jira/util/events/reasons');

    // Patch the projects admin workflows page when the workflow is ready.
    Events.bind(Types.NEW_CONTENT_ADDED, function (e, context, reason) {
        if (reason === Reasons.workflowReady && BrowserSupport.browserIsSupported()) {
            ProjectAdminWorkflows.replaceLink(
                context.find(".project-config-workflow-diagram"), context.find(".project-config-workflow-text-link"));
        }
    });
}());