AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:view-workflow-project-admin",
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var ProjectAdminWorkflows = require("workflow-designer/project-admin-workflows");
    var TestUtilities = require("workflow-designer/test-utilities");
    var TestMocks = require("workflow-designer/test-mocks");
    var jQuery = require("jquery");
    var Messages = require("jira/message");
    var Events = require("jira/util/events");
    var Reasons = require("jira/util/events/reasons");
    var Types = require("jira/util/events/types");

    module("ProjectAdminWorkflows", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.Application = TestMocks.Application();
            TestMocks.load(this.sandbox, this.Application);
            this.sandbox.stub(Messages, "showWarningMsg");

            this.fixture = jQuery("#qunit-fixture");
            this.viewAsTextLink = jQuery("<a data-workflowname=\"jira\">View As Text</a>");
            this.viewAsDiagramLink = jQuery("<a class=\"project-config-workflow-diagram\"/>");
            this.fixture.append(this.viewAsTextLink);
            this.fixture.append(this.viewAsDiagramLink);
        },

        teardown: function () {
            TestUtilities.removeDialogs();
            this.sandbox.restore();
        },

        patchPage: function () {
            ProjectAdminWorkflows.replaceLink(this.viewAsDiagramLink, this.viewAsTextLink);
        },

        getNewLink: function () {
            return this.fixture.find(".project-config-workflow-designer-link");
        }
    });

    test("Won't patch link on JIRA.Events.NEW_CONTENT_ADDED", function () {
        var replaceLinkSpy = this.sandbox.spy(ProjectAdminWorkflows, "replaceLink");

        Events.trigger(Types.NEW_CONTENT_ADDED, [jQuery("<div/>")]);

        equal(replaceLinkSpy.callCount, 0, "The link is not replaced until the workflow ready event is sent.");
    });

    test("Will patch link on JIRA.Events.NEW_CONTENT_ADDED workflowReady", function () {
        var replaceLinkSpy = this.sandbox.spy(ProjectAdminWorkflows, "replaceLink");
        var context = jQuery("<div/>");
        var diagramLink = jQuery("<a class=\"project-config-workflow-diagram\"/>").appendTo(context);
        var textLink = jQuery("<a class=\"project-config-workflow-text-link\"/>").appendTo(context);

        Events.trigger(Types.NEW_CONTENT_ADDED, [context, Reasons.workflowReady]);

        equal(replaceLinkSpy.callCount, 1, "The link is replaced when the workflow ready event is sent.");
        ok(replaceLinkSpy.args[0][0].get(0) === diagramLink.get(0), "The correct diagram element was passed to replaceLink()");
        ok(replaceLinkSpy.args[0][1].get(0) === textLink.get(0), "The correct text element was passed to replaceLink()");
    });

    test("Patched page has a View in designer link", function () {
        this.patchPage();

        ok(this.getNewLink().length, "View in designer link is added to page");
    });

    test("Clicking view in designer shows the workflow designer", function () {
        this.patchPage();
        this.getNewLink().click();

        ok(this.Application.called, "Workflow designer initialised");
    });

    test("Will not patch link on JIRA.Events.NEW_CONTENT_ADDED workflowReady as IE9", function () {
        var replaceLinkSpy = this.sandbox.spy(ProjectAdminWorkflows, "replaceLink");
        var context = jQuery("<div/>");
        jQuery("<a class=\"project-config-workflow-diagram\"/>").appendTo(context);
        jQuery("<a class=\"project-config-workflow-text-link\"/>").appendTo(context);

        TestUtilities.asIE(9, function () {
            Events.trigger(Types.NEW_CONTENT_ADDED, [context, Reasons.workflowReady]);
            equal(replaceLinkSpy.callCount, 0, "The link is not replaced when the workflow ready event is sent and we are in IE9.");
        });
    });

});
