AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:global-workflows",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var Positioner = require("workflow-designer/positioner");
    var WorkflowModel = require("workflow-designer/workflow-model");
    var draw2d = require("workflow-designer/draw-2d");
    var TestMocks = require("workflow-designer/test-mocks");

    module("Positioner", {
        mockStatusView: TestMocks.statusView,

        setup: function () {
            this.positionStatuses = Positioner.positionStatuses;
            this.viewBox = new draw2d.geo.Rectangle(0, 0, 1000, 1000);
            this.workflowModel = new WorkflowModel();
        }
    });

    test("positionStatuses() calculates the correct positions", function () {
        var statuses = [
            this.mockStatusView("I<1>", [100, 50], null, true),
            this.mockStatusView("S<1>", [50, 100]),
            this.mockStatusView("S<2>", [100, 50])
        ];

        sinon.stub(this.workflowModel, "getInitialTransitionDestinations").returns([statuses[2].model]);

        this.positionStatuses({statusViews: statuses, viewBox: this.viewBox, workflowModel: this.workflowModel});
        deepEqual(statuses[0].setPosition.args[0], [450, 70], "The first view was positioned correctly");
        deepEqual(statuses[1].setPosition.args[0], [475, 210], "The second view was positioned correctly");
        deepEqual(statuses[2].setPosition.args[0], [450, 140], "The third view was positioned correctly");
    });

    test("positionStatuses() only positions statuses without coordinates", function () {
        var result,
            statuses;

        statuses = [
            this.mockStatusView("S<1>", [100, 50]),
            this.mockStatusView("S<2>", [100, 50], [0, 0])
        ];

        result = this.positionStatuses({
            statusViews: statuses,
            viewBox: this.viewBox,
            workflowModel: this.workflowModel
        });
        equal(statuses[0].setPosition.callCount, 1, "The first view was positioned");
        equal(statuses[1].setPosition.callCount, 0, "The second view was not positioned");
        deepEqual([statuses[0]], result, "Only the first status was returned");
    });

});
