define("workflow-designer/line-start-resize-handle", [
    "workflow-designer/layout/connection/gapped-connection",
    "workflow-designer/line-resize-handle-mixin",
    "workflow-designer/draw-2d",
    "workflow-designer/cocktail"
], function(
    GappedConnection,
    LineResizeHandleMixin,
    draw2d,
    Cocktail
) {
    /**
     * @class JIRA.WorkflowDesigner.LineStartResizeHandle
     * @classdesc The resize handle for the startpoint of a connection
     * @extends draw2d.shape.basic.LineStartResizeHandle
     * @mixes JIRA.WorkflowDesigner.LineResizeHandleMixin
     */
    var LineStartResizeHandle = draw2d.shape.basic.LineStartResizeHandle.extend(
    /** @lends JIRA.WorkflowDesigner.LineStartResizeHandle.prototype */
    {
        /**
         * Gets the gap that needs to be applied to this resize handle, based on the gap defined in the connection
         *
         * @return {{x: number, y: number}} Gap to apply
         */
        getGap: function() {
            if (this.owner instanceof GappedConnection) {
                return this.owner.getStartPointGapTransformation();
            }
            return {x: 0, y: 0};
        },

        /**
         * @param {JIRA.WorkflowDesigner.StatusPort} port Port to get the drop targets for.
         * @returns {JIRA.WorkflowDesigner.StatusPort[]} Drop targets for the specified port.
         * @private
         */
        _getDropTargets: function(port) {
            return port.getAllTargetPorts();
        }
    });

    Cocktail.mixin(LineStartResizeHandle, LineResizeHandleMixin);

    return LineStartResizeHandle;
});

AJS.namespace("JIRA.WorkflowDesigner.LineStartResizeHandle", null, require("workflow-designer/line-start-resize-handle"));