AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:global-workflows","com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var E=require("workflow-designer/global-workflows");var D=require("jira/ajs/dark-features");var A=require("workflow-designer/test-utilities");var B=require("workflow-designer/test-mocks");var F=require("jquery");var C=require("workflow-designer/underscore");module("GlobalWorkflows",{setup:function(){this.sandbox=sinon.sandbox.create();this.Application=B.Application();B.load(this.sandbox,this.Application);this.qunitFixture=F("#qunit-fixture");this.workflowLinks=F("<div id='workflow-links'>").appendTo(this.qunitFixture);this.diagramLink=F("<div id='workflow-diagram'>").appendTo(this.workflowLinks);this.textLink=F("<div id='workflow-text'>").appendTo(this.workflowLinks);this.isOnDemand=this.sandbox.stub(D,"isEnabled").withArgs("com.atlassian.jira.config.CoreFeatures.ON_DEMAND").returns(false)},teardown:function(){this.sandbox.restore()},_setupWorkflowData:function(G){G=C.defaults({},G,{isDraft:true});G.isDraft&&this.qunitFixture.append(F("<span class='status-draft'>"));G.isInactive&&this.qunitFixture.append(F("<span class='status-inactive'>"));this.qunitFixture.append(F("<span class='workflow-name'>workflow<span>"));this.qunitFixture.append(F("<input id='workflow-designer-project' value='1000'>"));if(G.isEditable){this.qunitFixture.append(F("<span id='edit-workflow-trigger'>"))}},initEditMode:function(G){this._createWorkflowView();F("<div id='workflow-canvas'>").appendTo(this.workflowView);this.init(C.extend({},G,{isEditable:true}))},initViewMode:function(G){G=G||{};this._createWorkflowView();this.diagramLink.addClass("workflow-view-toggle");this.textLink.addClass("workflow-view-toggle");if(G.diagramModeActive){this.diagramLink.addClass("active")}else{this.workflowView.addClass("hidden")}this.init(G)},init:function(G){this._setupWorkflowData(G);new E()},_createWorkflowView:function(){this.workflowView=F("<div id='workflow-view-diagram'>").appendTo(this.qunitFixture)},testAnalyticsEvent:function(G){var H=AJS.EventQueue;try{AJS.EventQueue={push:sinon.spy()};G.call(this,AJS.EventQueue.push)}finally{AJS.EventQueue=H}}});test("Workflow designer is not created in text edit mode",function(){this.init({isEditable:true});equal(this.Application.callCount,0,"Workflow designer not initialised")});test("Workflow designer is created in edit page",function(){var G;this.initEditMode();G={draft:true,immutable:false,workflowId:"workflow"};equal(this.Application.callCount,1,"Workflow designer initialised");deepEqual(C.pick(this.Application.args[0][0],C.keys(G)),G,"It was passed the correct arguments")});test("Workflow designer is created in view page if diagram is selected initially",function(){var G,H;this.initViewMode({diagramModeActive:true});G=this.workflowView.find("#workflow-canvas");equal(G.length,1,"Canvas element was added");ok(G.is(":visible"),"Canvas element is visible");H={draft:true,immutable:true,workflowId:"workflow"};equal(this.Application.callCount,1,"Workflow designer initialised");deepEqual(C.pick(this.Application.args[0][0],C.keys(H)),H,"It was passed the correct arguments")});test("Workflow designer is created on view page when diagram is first selected (if not selected initially)",function(){var G,H;this.initViewMode();G=this.workflowView.find("#workflow-canvas");equal(G.length,1,"Canvas element was added");ok(G.is(":hidden"),"Canvas element is hidden");equal(this.Application.callCount,0,"Workflow designer not initialised initially");this.diagramLink.click();H={draft:true,immutable:true,workflowId:"workflow"};equal(this.Application.callCount,1,"Workflow designer initialised");deepEqual(C.pick(this.Application.args[0][0],C.keys(H)),H,"It was passed the correct arguments")});test("Feedback button is NOT added in edit mode in OnDemand",function(){this.isOnDemand.returns(true);this.initEditMode();equal(this.workflowLinks.find("#workflow-designer-feedback-trigger").length,0,"Feedback button was NOT added")});test("Feedback button is NOT added in view mode in OnDemand",function(){this.isOnDemand.returns(true);this.initViewMode();equal(this.workflowLinks.find("#workflow-designer-feedback-trigger").length,0,"Feedback button was NOT added")});test("Feedback button is not added in edit mode BTF",function(){this.initEditMode();equal(this.workflowLinks.find("#workflow-designer-feedback-trigger").length,0,"Feedback button was not added")});test("Feedback button is not added in view mode BTF",function(){this.initViewMode();equal(this.workflowLinks.find("#workflow-designer-feedback-trigger").length,0,"Feedback button was not added")});test("Feedback button is not added in IE9",function(){var G=this;this.isOnDemand.returns(true);A.asIE(9,function(){G.initEditMode();equal(G.workflowLinks.find("#workflow-designer-feedback-trigger").length,0,"Feedback button was not added")})});test("Message is shown instead of the workflow designer in edit mode in IE9",function(){var G=this;A.asIE(9,function(){G.initEditMode();equal(G.Application.callCount,0,"Workflow designer not initialised");equal(G.workflowView.find(".aui-message").length,1,"Message is shown")})});test("Open view mode analytics events is triggered upon opening if the diagram is selected initially",function(){this.testAnalyticsEvent(function(G){this.initViewMode({diagramModeActive:true});equal(G.callCount,1,"Triggered a single event");equal(G.args[0][0].name,"administration.workflow.open.view.global","It was an open view mode event")})});test("Open view mode analytics events is triggered upon switching to diagram if the diagram is not selected initially",function(){this.testAnalyticsEvent(function(G){this.initViewMode();this.diagramLink.click();equal(G.callCount,1,"Triggered a single event");equal(G.args[0][0].name,"administration.workflow.open.view.global","It was an open view mode event")})});test("Open view mode analytics events is not triggered upon opening inactive workflow",function(){this.testAnalyticsEvent(function(G){this.initViewMode({diagramModeActive:true,isInactive:true});equal(G.callCount,0,"Event not triggered")})});test("Open edit mode analytics events is triggered upon opening the draft workflow",function(){this.testAnalyticsEvent(function(G){this.initEditMode();equal(G.callCount,1,"Triggered a single event");equal(G.args[0][0].name,"administration.workflow.open.edit.global","It was an open edit mode event")})});test("Open edit mode analytics events is not triggered upon opening non-draft workflow",function(){this.testAnalyticsEvent(function(G){this.initEditMode({isDraft:false});equal(G.callCount,0,"Event not triggered")})})});