define("workflow-designer/draw-2d-view", [
    "workflow-designer/backbone"
], function(
    Backbone
) {
    return Backbone.View.extend({
        /**
         * Initialise the view.
         *
         * @classdesc A Backbone view with a Draw2D figure.
         * @constructs
         * @extends Backbone.View
         * @param {object} options
         * @param {draw2d.Canvas} options.canvas The Draw2D canvas to render to.
         */
        initialize: function (options) {
            this._canvas = options.canvas;
        },

        /**
         * Remove the view from the canvas.
         */
        remove: function () {
            Backbone.View.prototype.remove.apply(this, arguments);
            this._canvas.removeFigure(this._figure);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Draw2DView", null, require("workflow-designer/draw-2d-view"));