(function () {
    var draw2d = require("workflow-designer/draw-2d");
    var _ = require("workflow-designer/underscore");
    var originalSetText = draw2d.shape.basic.Label.prototype.setText;

    _.extend(draw2d.shape.basic.Label.prototype, {
        setText: function() {
            originalSetText.apply(this, arguments);

            // Calling setText sets the 'cachedHeight' and 'cachedMinHeight' properties to values that don't consider the new text dimensions.
            // Subsequent calls to getHeight() will return these cached values that were miscalculated.
            // Lets reset them - this will cause correct recalculation on next call to getHeight().
            this.cachedHeight = null;
            this.cachedMinHeight = null;
            this.cachedWidth = null;
            this.cachedMinWidth = null;
        }
    });
}());