define("workflow-designer/validator", [
    "workflow-designer/io/ajax/validation-ajax-manager",
    "workflow-designer/messages",
    "jira/ajs/dark-features",
    "workflow-designer/underscore"
], function(
    WorkflowValidationAJAXManager,
    Messages,
    DarkFeatures,
    _
) {
    var severityLevels = {
        MINOR: 1,
        MAJOR: 2,
        CRITICAL: 3
    };

    var getSeverity = function (validationResult) {
        if (!validationResult) {
            return 0;
        }
        var levels = _.map(validationResult, function (validation) {
            return severityLevels[validation.severity];
        });
        return _.max(levels) || 0;
    };

    var processResult = function (validationResult) {

        function processArray(problems) {
            var severity = getSeverity(problems);

            var result = {};

            result.alterDisplay = severity === 2 || severity === 3;
            result.color = result.alterDisplay && "#d04437";
            if (severity > 0) {
                result.mostSevere = _.last(_.sortBy(problems, function (problem) { return severityLevels[problem.severity]; }));
            }
            return result;
        }

        return _.object(_.map(validationResult, function (problems, key) {
            return [key, processArray(problems)];
        }));
    };

    var isValidationDisabled = function() {
        return DarkFeatures.isEnabled("jira.administration.workflow.validation.disabled");
    };

    /**
     * @namespace JIRA.WorkflowDesigner.Validator
     */
    return {
        serverityLevels: severityLevels,
        validate: function (workflowModel) {
            if (!isValidationDisabled()) {
                var workflowName = workflowModel.get("name");
                var request = WorkflowValidationAJAXManager.check(workflowName);
                request.done(function (response) {
                    workflowModel.trigger("validation:statuses", processResult(response.nodeProblems));
                    workflowModel.trigger("validation:transitions", processResult(response.edgeProblems));
                }).fail(function (errorMessage) {
                    return Messages.showErrorMessage(AJS.I18n.getText("workflow.designer.validation.error") + " " + errorMessage);
                });
            }
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.Validator", null, require("workflow-designer/validator"));