define("workflow-designer/messages", [
    "jira/message",
    "workflow-designer/underscore"
], function(
    Messages,
    _
) {
    /**
     * Message-related utility methods.
     *
     * @namespace
     */
    return {
        /**
         * Show a global, persistent error message.
         *
         * @param {string} message The message to show.
         * @param {object} [options]
         * @param {boolean} [options.closeable=false] Whether the error message can be closed.
         * @param {number} [options.timeout=0] The time before the message fades out.
         * @returns {jQuery} The error message element.
         */
        showErrorMessage: function (message, options) {
            var errorMessage;

            options = _.defaults({}, options, {
                closeable: true,
                timeout: 0
            });

            if (message) {
                errorMessage = Messages.showErrorMsg(message, options);
                errorMessage.css("z-index", 2510);
            }

            return errorMessage;
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.Messages", null, require("workflow-designer/messages"));