define("workflow-designer/draw2d-utilities", [], function() {
    /**
     * Draw2d utility methods.
     *
     * @namespace
     */
    return {
        /**
         * Set the cursor property for the passed figure.
         *
         * @param {draw2d.Figure} figure Figure to set the cursor property for.
         * @param {string} cursor Cursor property value to set.
         */
        setCursor: function (figure, cursor) {
            var target = figure.svgNodes || figure.shape;
            target && target.attr("cursor", cursor);
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.Draw2DUtilities", null, require("workflow-designer/draw2d-utilities"));