AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-loader","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var B=require("workflow-designer/analytics");var E=require("workflow-designer/io/ajax/user-properties-ajax-manager");var C=require("workflow-designer/underscore");var D=require("jquery");var A=require("workflow-designer/test-mocks");module("Analytics",{setup:function(){var F=this.sandbox=sinon.sandbox.create();if(AJS.Analytics){this.originalAnalytics=AJS.Analytics}else{this.originalAnalytics=null}AJS.EventQueue=[];AJS.Analytics={triggerPrivacyPolicySafeEvent:sinon.spy()};this.firstAddStepPropertyKey="jira.workflowdesigner.added.first.status";this.firstAddTransitionPropertyKey="jira.workflowdesigner.added.first.transition";this.getPropertyStub=F.stub(E,"getProperty");this.setPropertyStub=F.stub(E,"setProperty")},createPermissions:function(G,F,I,H){return{get:function(J){if(J==="administrator"){return G}else{if(J==="editPropertyOptions"){return F}else{if(J==="selectScreenOnTransition"){return I}else{if(J==="editWorkflow"){return H}}}}return false}}},teardown:function(){delete AJS.EventQueue;B._reset();AJS.Analytics=this.originalAnalytics;this.sandbox.restore()}});test("Triggering events",function(){var F=[["triggerAddStatus",["add","status"]],["triggerUpdateStatus",["update","status"]],["triggerAddStep",["add","step"]],["triggerUpdateStep",["update","step"]],["triggerRemoveStep",["remove","step"]],["triggerAddTransition",["add","transition"]],["triggerUpdateTransition",["update","transition"]],["triggerRemoveTransition",["remove","transition"]],["triggerAddGlobalTransition",["add","globaltransition"]],["triggerUpdateGlobalTransition",["update","globaltransition"]],["triggerRemoveGlobalTransition",["remove","globaltransition"]]];C.each(F,function(J){B[J[0]]();var G=A.analyticsEditEvent.apply(null,J[1]),I=C.last(AJS.EventQueue),H="The method "+J[0]+"() triggers an event with the expected values";deepEqual(I,G,H)},this)});test("Triggering click events",function(){D("<a class='enter-full-screen'>").appendTo("#qunit-fixture").click();ok(AJS.Analytics.triggerPrivacyPolicySafeEvent.calledWith("administration.workflow.fullscreen"),"A fullscreen event was triggered");var F=[["properties.key","administration.workflow.view.transition.properties"],["com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-transitions-tab","administration.workflow.view.transition.triggers-transitions-tab"],["com.atlassian.jira.plugin.system.workfloweditor.transition.tabs:conditions","administration.workflow.view.transition.conditions"],["com.atlassian.jira.plugin.system.workfloweditor.transition.tabs:validators","administration.workflow.view.transition.validators"],["com.atlassian.jira.plugin.system.workfloweditor.transition.tabs:postfunctions","administration.workflow.view.transition.postfunctions"]];C.each(F,function(G){D("<a data-transition-option-key='"+G[0]+"'>").appendTo("#qunit-fixture").click();ok(AJS.Analytics.triggerPrivacyPolicySafeEvent.calledWith(G[1]),"Event with expected name was triggered: "+G[1])})});test("Triggering toggle labels event",function(){B.triggerToggleLabels(true);equal(C.last(AJS.EventQueue).name,"administration.workflow.toggle.labels.on","Toggle labels on event was triggered");B.triggerToggleLabels(false);equal(C.last(AJS.EventQueue).name,"administration.workflow.toggle.labels.off","Toggle labels off event was triggered")});test("Subsequent triggerFirstAddStatus() calls don't make AJAX requests",function(){var F={key:this.firstAddStepPropertyKey,value:true};this.getPropertyStub.returns(D.Deferred().resolve(F));B.triggerFirstAddStatus(42);B.triggerFirstAddStatus(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was only called once")});test("triggerFirstAddStatus()",function(){var F=D.Deferred();this.getPropertyStub.returns(F);B.triggerFirstAddStatus(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was called");deepEqual(this.getPropertyStub.args[0],[this.firstAddStepPropertyKey],"It was passed the correct argument");F.resolve({key:this.firstAddStepPropertyKey,value:null});equal(C.last(AJS.EventQueue).name,"administration.workflow.first.add.status","A first add step event was triggered");deepEqual(C.last(AJS.EventQueue).properties,{duration:42},"It has the correct properties");equal(this.setPropertyStub.callCount,1,"UserPropertiesAJAXManager#setProperty was called");deepEqual(this.setPropertyStub.args[0],[this.firstAddStepPropertyKey,true],"It was passed the correct arguments")});test("triggerFirstAddStatus() fails silently",function(){var F=D.Deferred().reject();this.getPropertyStub.returns(F);B.triggerFirstAddStatus(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty() wasn't called")});test("triggerFirstAddStatus() only triggers an event for the user's first status",function(){var F={key:this.firstAddStepPropertyKey,value:true};this.getPropertyStub.returns(D.Deferred().resolve(F));B.triggerFirstAddStatus(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty wasn't called")});test("Subsequent triggerFirstAddTransition() calls don't make AJAX requests",function(){var F={key:this.firstAddTransitionPropertyKey,value:true};this.getPropertyStub.returns(D.Deferred().resolve(F));B.triggerFirstAddTransition(42);B.triggerFirstAddTransition(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was only called once")});test("triggerFirstAddTransition()",function(){var F=D.Deferred();this.getPropertyStub.returns(F);B.triggerFirstAddTransition(42);equal(this.getPropertyStub.callCount,1,"UserPropertiesAJAXManager#getProperty was called");deepEqual(this.getPropertyStub.args[0],[this.firstAddTransitionPropertyKey],"It was passed the correct argument");F.resolve({key:this.firstAddTransitionPropertyKey,value:null});equal(C.last(AJS.EventQueue).name,"administration.workflow.first.add.transition","A first add transition event was triggered");deepEqual(C.last(AJS.EventQueue).properties,{duration:42},"It has the correct properties");equal(this.setPropertyStub.callCount,1,"UserPropertiesAJAXManager#setProperty was called");deepEqual(this.setPropertyStub.args[0],[this.firstAddTransitionPropertyKey,true],"It was passed the correct arguments")});test("triggerFirstAddStatus() fails silently",function(){var F=D.Deferred().reject();this.getPropertyStub.returns(F);B.triggerFirstAddTransition(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty() wasn't called")});test("triggerFirstAddStatus() only triggers an event for the user's first status",function(){var F={key:this.firstAddTransitionPropertyKey,value:true};this.getPropertyStub.returns(D.Deferred().resolve(F));B.triggerFirstAddTransition(42);equal(AJS.EventQueue.length,0,"No analytics event was triggered");equal(this.setPropertyStub.callCount,0,"UserPropertiesAJAXManager#setProperty wasn't called")});test("additional permissions with editWorkflow affects analytics key",function(){var F=this.createPermissions(false,false,false,true);B.triggerAddStatus(F);equal(AJS.EventQueue.length,1,"One analytics event should be triggered");deepEqual(C.last(AJS.EventQueue),{name:"administration.workflow.editworkflowpermission.edit",properties:{mode:"new-diagram",action:"add",object:"status"}},"Correct event is produced")});test("simultanous administrator and editWorkflow permissions should not affect analytics key",function(){var F=this.createPermissions(true,false,false,true);B.triggerAddStatus(F);equal(AJS.EventQueue.length,1,"One analytics event should be triggered");deepEqual(C.last(AJS.EventQueue),{name:"administration.workflow.edit",properties:{mode:"new-diagram",action:"add",object:"status"}},"Correct event is produced")})});