AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-loader",
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var ApplicationLoader;
    var WRMRequire;
    var Application;
    var jQuery = require("jquery");

    module("ApplicationLoader", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.context = AJS.test.mockableModuleContext();

            this.context.mock("workflow-designer/application", require("workflow-designer/application"));
            Application = this.context.require("workflow-designer/application");
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("load() uses WRM.require to load the correct context", sinon.test(function () {
        this.context.mock("wrm/require", sinon.stub());
        WRMRequire = this.context.require("wrm/require");
        ApplicationLoader = this.context.require("workflow-designer/application-loader");

        ApplicationLoader.load();

        ok(WRMRequire.calledOnce);
        deepEqual(WRMRequire.firstCall.args[0], ["wrc!com.atlassian.jira.plugins.jira-workflow-designer.workflow-designer"]);
    }));

    test("load() invokes its callback with the workflow designer application after WRM.require is done", sinon.test(function () {
        this.context.mock("wrm/require", sinon.stub());
        WRMRequire = this.context.require("wrm/require");
        ApplicationLoader = this.context.require("workflow-designer/application-loader");

        var callback = sinon.spy();

        // Change the original object to make sure it is the same as the one in the arguments
        this.sandbox.spy(Application.prototype, "_initialiseWorkflow");

        ApplicationLoader.load(callback);
        WRMRequire.firstCall.args[1](); // mimic WRM.require calling _its_ callback

        ok(callback.calledOnce);
        deepEqual(callback.firstCall.args, [Application]);
    }));

    test("load() returns a promise that is resolved on success", sinon.test(function () {
        var requiring;
        var wrmRequireResult = jQuery.Deferred();
        sinon.stub().returns(wrmRequireResult);
        this.context.mock("wrm/require", sinon.stub().returns(wrmRequireResult));
        WRMRequire = this.context.require("wrm/require");
        ApplicationLoader = this.context.require("workflow-designer/application-loader");

        requiring = ApplicationLoader.load();

        equal(requiring.state(), "pending");

        wrmRequireResult.resolve();

        equal(requiring.state(), "resolved");
    }));

    test("load() returns a promise that is reject on failure", sinon.test(function () {
        var requiring;
        var wrmRequireResult = jQuery.Deferred();
        sinon.stub().returns(wrmRequireResult);
        this.context.mock("wrm/require", sinon.stub().returns(wrmRequireResult));
        WRMRequire = this.context.require("wrm/require");
        ApplicationLoader = this.context.require("workflow-designer/application-loader");


        requiring = ApplicationLoader.load();

        equal(requiring.state(), "pending");

        wrmRequireResult.reject();

        equal(requiring.state(), "rejected");
    }));

});
