AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var StatusPortsFeedbackPolicy = require("workflow-designer/policy/feedback/status-ports-feedback-policy");
    var TestUtilities = require("workflow-designer/test-utilities");
    var draw2d = require("workflow-designer/draw-2d");

    module("StatusPortsFeedbackPolicy", {
        setup: function () {
            this.canvas = TestUtilities.testDraw2DCanvas();
            this.statusPortsFeedbackPolicy = new StatusPortsFeedbackPolicy();
        }
    });

    test("The connection line is the correct colour", function () {
        var port;

        port = new draw2d.Port();
        port.parent = new draw2d.Figure();
        port.targets = new draw2d.util.ArrayList();

        this.statusPortsFeedbackPolicy.onDragStart(this.canvas, port);
        equal(this.statusPortsFeedbackPolicy.connectionLine.getColor().hash(), "#1A8CFF", "Its colour is correct");
    });

});
