define("workflow-designer/policy/canvas/snapper", [
    "workflow-designer/underscore"
], function(
    _
) {
    /**
     * Initialise the instance.
     *
     * @class
     * @classdesc Snaps values to a known set of points.
     * @param {number[]} points The points to snap to.
     */
    var Snapper = function (points) {
        _.bindAll(this, "snap");

        this.points = points;
    };

    Snapper.prototype = {
        /**
         * Snap a value to its closest point.
         *
         * @param {number} value The value to snap.
         * @return {number} The offset required to snap <tt>value</tt> to its closest point.
         */
        snap: function (value) {
            function getOffset(point) {
                return point - value;
            }

            if (this.points.length === 0) {
                return 0;
            }

            return _.chain(this.points)
                    .map(getOffset)
                    .min(Math.abs)
                    .value();
        }
    };

    return Snapper;
});

AJS.namespace("JIRA.WorkflowDesigner.Policy.Canvas.SnapToGeometry.Snapper", null, require("workflow-designer/policy/canvas/snapper"));