AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var Snapper = require("workflow-designer/policy/canvas/snapper");
    var _ = require("workflow-designer/underscore");

    module("Snapper", {
        setup: function () {
            this.snapper = Snapper;
        }
    });

    test("snap() returns 0 if it has no points", function () {
        var snapper = new this.snapper([]);
        equal(snapper.snap(1), 0, "snap() returned 0");
    });

    test("When passed a single value, snap() returns the offset to its nearest point", function () {
        var snapper = new this.snapper([1, 4]),
            tests;

        tests = [
            [0.0, 1.0],
            [0.5, 0.5],
            [1.0, 0.0],
            [1.5, -0.5],
            [2.0, -1.0],
            [2.5, -1.5],
            [3.0, 1.0],
            [3.5, 0.5],
            [4.0, 0.0],
            [4.5, -0.5],
            [5.0, -1.0]
        ];

        _.each(tests, function (test) {
            equal(snapper.snap(test[0]), test[1], "snap(" + test[0] + ") returned " + test[1]);
        });
    });

});
