define("workflow-designer/policy/canvas/panning-single-selection-policy", [
    "workflow-designer/viewbox-transformer",
    "workflow-designer/vector-2d",
    "workflow-designer/draw-2d",
    "aui/inline-dialog"
], function(
    ViewBoxTransformer,
    Vector2D,
    draw2d,
    InlineDialog
) {

    return draw2d.policy.canvas.SingleSelectionPolicy.extend(
    /** @lends JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy# */
    {
        /**
         * Initialise this policy
         *
         * @classdesc A Draw2D single selection policy that implements panning by modifying the canvas view box.
         * @constructs
         * @extend draw2d.policy.canvas.SingleSelectionPolicy
         * @param {function} getCanvasBoundingBox Function used to get the canvas bounding box.
         */
        init: function (getCanvasBoundingBox) {
            this._super();
            this._getCanvasBoundingBox = getCanvasBoundingBox;
        },

        /**
         * Handler for mousedown event.
         *
         * @param {JIRA.WorkflowDesigner.Draw2DCanvas} canvas Canvas where this policy is installed.
         * @param {number} x The x-coordinate of the mouse down event.
         * @param {number} y The y-coordinate of the mouse down event.
         */
        onMouseDown: function (canvas, x, y) {
            // Panning hides modal views.
            InlineDialog.current && InlineDialog.current.hide();
            this._super(canvas, x, y);
            this._initialViewBox = canvas.getViewBox();
            this._boundingBox = this._getCanvasBoundingBox();
        },

        /**
         * Handler for the mousedrag action.
         *
         * @param {JIRA.WorkflowDesigner.Draw2DCanvas} canvas Canvas where this policy is installed.
         * @param {number} dx The x diff between start of dragging and this event.
         * @param {number} dy The y diff between start of dragging and this event.
         * @param {number} dx2 The x diff since the last call of this dragging operation.
         * @param {number} dy2 The y diff since the last call of this dragging operation.
         */
        onMouseDrag: function (canvas, dx, dy, dx2, dy2) {
            this._super(canvas, dx, dy, dx2, dy2);

            if (this.mouseDownElement === null && this.mouseDraggingElement === null) {
                // Use setViewBoxQuick to avoid Raphael's implementation. Raphael will redraw every single line to
                // maintain the 1px width, and in slow browsers (i.e. IE9) this is an expensive operation.
                canvas.setViewBoxQuick(ViewBoxTransformer.getPanViewBox({
                    diagramBoundingBox: this._boundingBox,
                    displacement: new Vector2D(-dx, -dy),
                    viewBox: this._initialViewBox
                }));
            }
        }

    });
});

AJS.namespace("JIRA.WorkflowDesigner.Policy.Canvas.PanningSingleSelectionPolicy", null, require("workflow-designer/policy/canvas/panning-single-selection-policy"));