AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var StaticLocator = require("workflow-designer/layout/locator/static-locator");
    var _ = require("workflow-designer/underscore");

    module("StaticLocator", {
        assertRelocate: function (x, y) {
            var locator = new StaticLocator(null, x, y),
                target = {setPosition: sinon.spy()};

            locator.relocate(0, target);

            equal(target.setPosition.callCount, 1, "The target's setPosition() method was called");
            deepEqual(target.setPosition.args[0], [x, y], "It was called with the correct arguments");
        }
    });

    test("relocate()", function () {
        var tests = [
            [-1, -1],
            [0, 0],
            [1, 1]
        ];

        _.each(tests, function (test) {
            this.assertRelocate.apply(this, test);
        }, this);
    });

});
