AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var ManhattanPercentageLocator = require("workflow-designer/layout/locator/manhattan-percentage-locator");
    var draw2d = require("workflow-designer/draw-2d");
    var _ = require("workflow-designer/underscore");

    module("ManhattanPercentageLocator", {
        /**
         * @returns {draw2d.shape.basic.PolyLine} A Draw2D polyline.
         */
        createPolyline: function () {
            return _.reduce(arguments, function (polyline, point) {
                polyline.addPoint.apply(polyline, point);
                return polyline;
            }, new draw2d.shape.basic.PolyLine());
        },

        /**
         * Create a target object to pass to `#relocate`.
         *
         * @param {number} width The target's width.
         * @param {number} height The target's height.
         * @returns {object} The target object.
         */
        createTarget: function (width, height) {
            return {
                getHeight: sinon.stub().returns(height),
                getWidth: sinon.stub().returns(width),
                setPosition: sinon.spy()
            };
        }
    });

    test("#relocate", function () {
        var size = [10, 4],
            tests;

        tests = [
            // test: [percentage, expected-result, line]
            // line: [[x, y], [x, y], ...]

            // Straight Lines
            [0.00, [-5, -2], [[0, 0], [10, 0]]],
            [0.10, [4, -2], [[10, 0], [0, 0]]],
            [0.50, [-5, -5], [[0, 0], [0, -6]]],
            [0.50, [-5, -2], [[0, 0], [0, 0]]],
            [1.00, [5, 18], [[0, 10], [10, 20]]],

            // One Corner
            [0.25, [0, -2], [[0, 0], [10, 0], [10, 10]]],
            [0.50, [-5, -2], [[10, 0], [0, 0], [0, 10]]],

            // Multiple Corners
            [0.50, [5, 3], [[0, 0], [10, 0], [10, 10], [0, 10]]]
        ];

        _.each(tests, function (test) {
            var expected = {x: test[1][0], y: test[1][1]},
                line = this.createPolyline.apply(this, test[2]),
                locator = new ManhattanPercentageLocator(line, test[0]),
                target = this.createTarget.apply(this, size);

            locator.relocate(0, target);
            ok(target.setPosition.args[0][0].equals(expected));
        }, this);
    });

    test("#relocate with no line segments", function () {
        var line = this.createPolyline(),
            locator = new ManhattanPercentageLocator(line, 0.5),
            target = this.createTarget(0, 0);

        locator.relocate(0, target);
        equal(target.setPosition.callCount, 0, "setPosition wasn't called");
    });

});
