AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var C=require("workflow-designer/io/ajax/workflow-ajax-manager");var B=require("workflow-designer/workflow-model");var A=require("wrm/context-path");module("WorkflowAJAXManager",{setup:function(){this.sandbox=sinon.sandbox.create({useFakeServer:true})},teardown:function(){this.sandbox.restore()}});test("Successfully loading a workflow",function(){var E=C.load("Workflow"),D;D={layout:simpleLayoutJSON,liveStepIds:[1,2]};this.sandbox.server.respondWith(JSON.stringify(D));this.sandbox.server.respond();equal(E.state(),"resolved","The returned deferred is resolved on success");E.done(function(G,F){equal(arguments.length,2,"The deferred was resolved with two arguments");ok(G.updatedDate.getTime()===100000,"The correct last updated date was loaded");deepEqual(G.updateAuthor,{userName:"bob",displayName:"Bob Dude"},"The correct last updater details were loaded");deepEqual(G.liveStepIds,[1,2],"The correct live step ID-s were loaded");equal(G.statuses.length,6,"The correct number of statuses were loaded");equal(G.transitions.length,4,"The correct number of transitions were loaded");deepEqual(F,D,"The JSON response was passed to the done handler")})});test("Unsuccessfully loading a workflow because server rejected request.",function(){var D=C.load("workflow");this.sandbox.server.respond();equal(D.state(),"rejected","The returned deferred is rejected on failure")});test("Successfully saving a workflow",function(){var D=C.save(new B());this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows","");this.sandbox.server.respond();equal(D.state(),"resolved","The returned deferred is resolved on success")});test("Unsuccessfully saving a workflow because server rejected request.",function(){var D=C.save(new B());this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows",[400,{},"Page not found"]);this.sandbox.server.respond();equal(D.state(),"rejected","The returned deferred is rejected on failure");D.fail(function(E){equal(E,"Page not found","Callback received the right response")})});test("Call to save a workflow was rejected because a draft was already being published or discarded.",function(){var E,D=new B();C.publish(D);this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows/publishDraft","");E=C.save(D);this.sandbox.server.respond();equal(E.state(),"pending","The save promise is pending when a draft was already being published or discarded.");equal(this.sandbox.server.requests.length,1,"Only the publish request was made");equal(this.sandbox.server.requests[0].url,A()+"/rest/workflowDesigner/latest/workflows/publishDraft","The only request is to publish")});test("A successful workflow publish returns a resolved promise",1,function(){var D=C.publish(new B());this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows/publishDraft","");this.sandbox.server.respond();equal(D.state(),"resolved","The returned deferred is resolved on success")});test("Unsuccessfully publishing a workflow because server rejected request.",2,function(){var D=C.publish(new B());this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows/publishDraft",[400,{},"Bad request"]);this.sandbox.server.respond();equal(D.state(),"rejected","The returned promise is rejected on failure");D.fail(function(E){equal(E,"Bad request","Callback received the right response")})});test("A successful workflow discard returns a resolved promise",1,function(){var D=C.discard("workflow");this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows/discardDraft","");this.sandbox.server.respond();equal(D.state(),"resolved","The returned deferred is resolved on success")});test("Unsuccessfully discarding a workflow because server rejected request.",2,function(){var D=C.discard("Workflow");this.sandbox.server.respondWith(A()+"/rest/workflowDesigner/latest/workflows/discardDraft",[400,{},"Bad request"]);this.sandbox.server.respond();equal(D.state(),"rejected","The returned deferred is rejected on failure");D.fail(function(E){equal(E,"Bad request","Callback received the right response")})})});