define("workflow-designer/io/ajax/validation-ajax-manager", [
    "workflow-designer/io/ajax/ajax-manager",
    "workflow-designer/io/error-handler",
    "workflow-designer/underscore",
    "jquery",
    "wrm/context-path"
], function(
    AJAXManager,
    ErrorHandler,
    _,
    jQuery,
    contextPath
) {
    var URL = contextPath() + "/rest/workflowDesigner/latest/workflows/validation";

    function makeRequest(options) {
        var deferred = jQuery.Deferred();

        var request = this._makeRequest(_.defaults({}, options, {
            dataType: "json",
            url: URL
        }));

        request.done(deferred.resolve);
        request.fail(function (response, status) {
            deferred.reject(ErrorHandler.getErrorMessage(response, status));
        });

        return deferred.promise();
    }

    return _.extend({}, AJAXManager,
    {
        check: function (workflowName) {
            return makeRequest.call(this, {
                data: JSON.stringify({"workflowName": workflowName}),
                type: "post",
                contentType: "application/json"
            });
        }
    });

});

AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.ValidationAJAXManager", null, require("workflow-designer/io/ajax/validation-ajax-manager"));