define("workflow-designer/io/ajax/status-categories-ajax-manager", [
    "workflow-designer/io/ajax/ajax-manager",
    "workflow-designer/io/error-handler",
    "workflow-designer/underscore",
    "jquery",
    "wrm/context-path"
], function(
    AJAXManager,
    ErrorHandler,
    _,
    jQuery,
    contextPath
) {
    var statusCategories;

    /**
     * Handles retrieving status categories via AJAX.
     *
     * @namespace
     * @extends JIRA.WorkflowDesigner.IO.AJAX.AJAXManager
     */
    return _.extend({}, AJAXManager,
        /** @lends JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager */
        {
            /**
             * Retrieve information about all status categories in the system.
             *
             * @return {jQuery.Deferred} A deferred that is resolved with status category data.
             */
            getStatusCategories: function () {
                var deferred = jQuery.Deferred(),
                    request;

                if (statusCategories) {
                    deferred.resolve(statusCategories);
                } else {
                    request = this._makeRequest({
                        dataType: "json",
                        url: contextPath() + "/rest/workflowDesigner/latest/statusCategories"
                    });

                    request.done(function (response) {
                        statusCategories = response;
                        deferred.resolve(statusCategories);
                    });

                    request.fail(function (response, status) {
                        deferred.reject(ErrorHandler.getErrorMessage(response, status));
                    });
                }

                return deferred.promise();
            },

            /**
             * Reset the manager, clearing its cache.
             */
            reset: function () {
                statusCategories = undefined;
            }
        });
});

AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.StatusCategoriesAJAXManager", null, require("workflow-designer/io/ajax/status-categories-ajax-manager"));