AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var ProjectConfigAJAXManager = require("workflow-designer/io/ajax/project-config-ajax-manager");
    var $ = require("jquery");

    module("ProjectConfigAJAXManager", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.makeRequestStub = this.sandbox.stub(ProjectConfigAJAXManager, "_makeRequest");
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Successfully loading a draft workflow if available", function () {
        var deferred,
            expectedResponse;

        expectedResponse = {
            isDraft: true,
            layout: simpleLayoutJSON,
            liveStepIds: [1, 2]
        };

        this.makeRequestStub.returns($.Deferred().resolve(expectedResponse).promise());

        deferred = ProjectConfigAJAXManager.loadDraftWorkflowIfAvailable({name: "Workflow"});

        equal(deferred.state(), "resolved", "The returned deferred is resolved on success");
        deferred.done(function (isDraft, layout, response) {
            equal(arguments.length, 3, "The deferred was resolved with three arguments");
            ok(isDraft, "The correct isDraft flag is set");
            ok(layout.updatedDate.getTime() === 100000, "The correct last updated date was loaded");
            deepEqual(layout.updateAuthor, {
                userName: "bob",
                displayName: "Bob Dude"
            }, "The correct last updater details were loaded");
            deepEqual(layout.liveStepIds, [1, 2], "The correct live step ID-s were loaded");
            equal(layout.statuses.length, 6, "The correct number of statuses were loaded");
            equal(layout.transitions.length, 4, "The correct number of transitions were loaded");
            deepEqual(response, expectedResponse, "The JSON response was passed to the done handler");
        });
    });

    test("Unsuccessfully loading a draft workflow if available", function () {
        var deferred;

        this.makeRequestStub.returns($.Deferred().reject().promise());

        deferred = ProjectConfigAJAXManager.loadDraftWorkflowIfAvailable({name: "workflow"});
        equal(deferred.state(), "rejected", "The returned deferred is rejected on failure");
    });

    test("Successfully loading or creating a draft workflow", function () {
        var deferred,
            expectedResponse;

        expectedResponse = {
            isDraft: true,
            layout: simpleLayoutJSON,
            liveStepIds: [1, 2]
        };

        this.makeRequestStub.returns($.Deferred().resolve(expectedResponse).promise());

        deferred = ProjectConfigAJAXManager.loadOrCreateDraftWorkflow({name: "Workflow"});

        equal(deferred.state(), "resolved", "The returned deferred is resolved on success");
        deferred.done(function (isDraft, layout, response) {
            equal(arguments.length, 3, "The deferred was resolved with three arguments");
            ok(isDraft, "The correct isDraft flag is set");
            ok(layout.updatedDate.getTime() === 100000, "The correct last updated date was loaded");
            deepEqual(layout.updateAuthor, {
                userName: "bob",
                displayName: "Bob Dude"
            }, "The correct last updater details were loaded");
            deepEqual(layout.liveStepIds, [1, 2], "The correct live step ID-s were loaded");
            equal(layout.statuses.length, 6, "The correct number of statuses were loaded");
            equal(layout.transitions.length, 4, "The correct number of transitions were loaded");
            deepEqual(response, expectedResponse, "The JSON response was passed to the done handler");
        });
    });

    test("Unsuccessfully loading or creating a draft workflow", function () {
        var deferred;

        this.makeRequestStub.returns($.Deferred().reject().promise());

        deferred = ProjectConfigAJAXManager.loadOrCreateDraftWorkflow({name: "workflow"});
        equal(deferred.state(), "rejected", "The returned deferred is rejected on failure");
    });
});
