define("workflow-designer/io/ajax/ajax-manager", [
    "jira/ajs/ajax/smart-ajax/web-sudo",
    "workflow-designer/underscore",
    "jquery"
], function(
    WebSudo,
    _,
    jQuery
) {
    /**
     * The base AJAX manager object.
     *
     * @namespace
     */
    return {
        /**
         * Make an AJAX request.
         *
         * Attaches a CSRF token to the request and handles WebSudo.
         *
         * @param {object} options Options to pass to `jQuery.ajax()`.
         * @protected
         */
        _makeRequest: function (options) {
            var deferred = jQuery.Deferred(),
                request;

            options.headers = _.extend({}, options.headers, {
                "X-Atlassian-Token": "no-check"
            });

            request = WebSudo.makeWebSudoRequest(options, {
                cancel: function (e) {
                    // Rejection must be deferred to ensure that the WebSudo
                    // dialog has closed and the original one is restored.
                    _.defer(deferred.reject, undefined, "abort");
                    e.preventDefault();
                }
            });

            request.done(deferred.resolve);
            request.fail(deferred.reject);
            return deferred.promise();
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.AJAXManager", null, require("workflow-designer/io/ajax/ajax-manager"));