AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var _ = require("workflow-designer/underscore");
    var jQuery = require("jquery");
    var AJAXManager = require("workflow-designer/io/ajax/ajax-manager");
    var WebSudo = require("jira/ajs/ajax/smart-ajax/web-sudo");

    module("AJAXManager", {
        setup: function () {
            this.ajaxManager = _.extend({}, AJAXManager, {
                makeRequest: function () {
                    return this._makeRequest.apply(this, arguments);
                }
            });

            this.sandbox = sinon.sandbox.create({
                useFakeServer: true
            });
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("Attaches a CSRF token to requests", function () {
        var getHeaders, postHeaders;

        var fixture = jQuery("#qunit-fixture");

        AJS.namespace("AJS.params.loggedInUser", window, "admin");
        jQuery("<meta>").attr({
            name: "ajs-remote-user",
            content: "admin"
        }).appendTo(fixture);

        getHeaders = {
            "Accept": "*/*",
            "X-Atlassian-Token": "no-check",
            "X-AUSERNAME": "admin",
            "X-Requested-With": "XMLHttpRequest"
        };

        postHeaders = {
            "Accept": "*/*",
            "Content-Type": "text/plain;charset=utf-8",
            "X-Atlassian-Token": "no-check",
            "X-AUSERNAME": "admin",
            "X-Requested-With": "XMLHttpRequest"
        };

        // GET
        this.ajaxManager.makeRequest({url: "/"});
        equal(this.sandbox.server.requests.length, 1, "A GET request was made");
        deepEqual(this.sandbox.server.requests[0].requestHeaders, getHeaders, "It contains a CSRF token header");

        // POST
        this.ajaxManager.makeRequest({type: "POST", url: "/"});
        equal(this.sandbox.server.requests.length, 2, "A POST request was made");
        deepEqual(this.sandbox.server.requests[1].requestHeaders, postHeaders, "It contains a CSRF token header");
    });

    test("Handles cancellation of the WebSudo dialog", function () {
        var cancel,
            event = {preventDefault: sinon.spy()},
            makeWebSudoRequestStub = this.sandbox.stub(WebSudo, "makeWebSudoRequest").returns(jQuery.Deferred()),
            request,
            clock = sinon.useFakeTimers();

        request = this.ajaxManager.makeRequest({});
        equal(makeWebSudoRequestStub.callCount, 1, "SmartAjax.makeWebSudoRequest was called");

        // Call AJAXManager's cancellation handler.
        cancel = makeWebSudoRequestStub.args[0][1].cancel;
        cancel(event);

        clock.tick(100);

        equal(event.preventDefault.callCount, 1, "The event's preventDefault method was called");
        equal(request.state(), "rejected", "The request deferred was rejected");

        clock.restore();
    });

});
