AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var WorkflowDataWriter = require("workflow-designer/io/workflow-data-writer");
    var WorkflowModel = require("workflow-designer/workflow-model");
    var _ = require("workflow-designer/underscore");

    module("WorkflowDataWriter", {
        setup: function () {
            this.workflowModel = new WorkflowModel({
                name: "Workflow",
                liveStepIds: [1]
            });
            this.write = WorkflowDataWriter.write;
        }
    });

    test("write()", function () {
        var expectedResult,
            instance = this,
            statusesToSave = [],
            transitionsToSave = [];

        function findStatus(id) {
            var statuses = instance.workflowModel.get("statuses").models;
            return _.where(statuses, {id: id})[0];
        }

        _.each(simpleLayoutModelAttributes.statuses, function (attributes) {
            statusesToSave.push(_.pick(attributes, "id", "x", "y"));
            instance.workflowModel.addStatus(attributes);
        });

        _.each(simpleLayoutModelAttributes.transitions, function (attributes) {
            transitionsToSave.push(_.pick(attributes, "id", "sourceAngle", "sourceId", "targetAngle", "targetId"));

            attributes = _.chain(attributes).omit("sourceId", "targetId").extend({
                source: findStatus(attributes.sourceId),
                target: findStatus(attributes.targetId)
            }).value();

            instance.workflowModel.addTransition(attributes);
        });

        expectedResult = {
            draft: false,
            name: "Workflow",
            layout: {
                statuses: statusesToSave,
                transitions: transitionsToSave
            }
        };

        deepEqual(this.write(this.workflowModel), expectedResult, "write() returned the correct JSON");
    });

    test("write() returns the correct source IDs for global transitions", function () {
        this.workflowModel.addTransition({
            globalTransition: true,
            target: this.workflowModel.addStatus({id: "status"})
        });

        equal(this.write(this.workflowModel).layout.transitions[0].sourceId, "status",
            "The transition's source ID is correct");
    });

});
