AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var WorkflowDataReader = require("workflow-designer/io/workflow-data-reader");
    var _ = require("workflow-designer/underscore");

    module("WorkflowDataReader", {
        setup: function () {
            this.read = WorkflowDataReader.read;
        }
    });

    test("Calling read() with no arguments returns undefined", function () {
        equal(this.read(), undefined, "read() returned undefined");
    });

    test("Reading invalid workflow JSON", function () {
        var invalidData = {
            "an empty object": {},
            "an object with no statuses": {transitions: []},
            "an object with no transitions": {statuses: []}
        };

        _.each(invalidData, _.bind(function (data, description) {
            equal(this.read(data), undefined,
                "Attempting to read " + description + " failed");
        }, this));
    });

    test("Reading valid workflow JSON", function () {
        var result;

        function getStatusWithId(id) {
            return _.where(result.statuses, {id: id})[0];
        }

        result = this.read(simpleLayoutJSON);
        equal(result.statuses.length, 6, "The correct number of statuses were loaded");
        equal(result.transitions.length, 4, "The correct number of transitions were loaded");
        equal(result.updatedDate.getTime(), 100000, "The correct last updated date was loaded");
        deepEqual(result.updateAuthor, {
            userName: "bob",
            displayName: "Bob Dude"
        }, "The correct update author was loaded");

        _.each(result.statuses, function (statusModel) {
            var expectedAttributes = _.where(simpleLayoutModelAttributes.statuses, {id: statusModel.id})[0];
            deepEqual(statusModel.attributes, expectedAttributes,
                "The \"" + statusModel.get("name") + "\" status was loaded correctly");
        });

        _.each(result.transitions, function (transitionModel) {
            var expectedAttributes;

            expectedAttributes = _.where(simpleLayoutModelAttributes.transitions, {actionId: transitionModel.get("actionId")})[0];
            expectedAttributes = _.chain(expectedAttributes).omit("sourceId", "targetId").extend({
                source: getStatusWithId(expectedAttributes.sourceId),
                target: getStatusWithId(expectedAttributes.targetId)
            }).value();

            deepEqual(transitionModel.attributes, expectedAttributes,
                "The \"" + transitionModel.get("name") + "\" transition was loaded correctly");
        });
    });

});
