define("workflow-designer/internal-api/panel-service", [
    "workflow-designer/panel-collection",
    "exports"
], function (
    PanelCollection,
    exports
) {

    var locations = {};

    /**
     * Assigns a panel to be rendered in a particular locaton for the workflow designer
     *
     * @param {string} location string representing the location of which the panel will be rendered
     * @param {object} descriptor
     * @param {function} descriptor.template function that renders the panel html
     * @param {number} descriptor.weight The weight of the panel, used to calculate what order panels for rendered for location.
     */
    exports.addPanel = function (location, descriptor) {
        locations[location] = locations[location] || new PanelCollection();
        locations[location].add(descriptor);
    };

    /**
     * Renders all the panels for a particular location of the workflow designer
     *
     * @param {string} location string representing the location of which the panel will be rendered
     * @param {object} context object provided to the template
     * @return {string[]} array of html strings
     */
    exports.renderPanels = function (location, context) {
        var collection = locations[location];
        return collection && collection.map(function (model) {
            return model.get("template")(context);
        });
    };
});