define("workflow-designer/transition-option-type-collection", [
    "workflow-designer/transition-option-type-model",
    "workflow-designer/backbone"
], function(
    TransitionOptionTypeModel,
    Backbone
) {
    /**
     * A collection of {@link JIRA.WorkflowDesigner.TransitionOptionTypeModel}s.
     *
     * @class JIRA.WorkflowDesigner.TransitionOptionTypeCollection
     * @extends Backbone.Collection
     */
    return Backbone.Collection.extend(
    /** @lends JIRA.WorkflowDesigner.TransitionOptionTypeCollection# */
    {
        /**
         * The model class that the collection contains
         *
         * @param {object} attributes
         * @param {object} options
         * @returns {JIRA.WorkflowDesigner.TransitionOptionTypeModel}
         */
        model: function (attributes, options) {
            return new TransitionOptionTypeModel(attributes, options);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.TransitionOptionTypeCollection", null, require("workflow-designer/transition-option-type-collection"));