define("workflow-designer/transition-collection", [
    "workflow-designer/transition-model",
    "workflow-designer/backbone"
], function(
    TransitionModel,
    Backbone
) {
    /**
     * A collection of {@link JIRA.WorkflowDesigner.TransitionModel}s.
     *
     * @class JIRA.WorkflowDesigner.TransitionCollection
     * @extends Backbone.Collection
     */
    return Backbone.Collection.extend(
    /** @lends JIRA.WorkflowDesigner.TransitionCollection# */
    {
        /**
         * The model class that the collection contains
         *
         * @param {object} attributes
         * @param {object} options
         * @returns {JIRA.WorkflowDesigner.TransitionModel}
         */
        model: function (attributes, options) {
            return new TransitionModel(attributes, options);
        },

        /**
         * Returns the initial transition
         *
         * @returns {JIRA.WorkflowDesigner.TransitionModel} Initial transition
         */
        getInitial: function () {
            return this.find(function (transition) {
                return transition.isInitial();
            });
        }

    });
});

AJS.namespace("JIRA.WorkflowDesigner.TransitionCollection", null, require("workflow-designer/transition-collection"));