define("workflow-designer/status-collection", [
    "workflow-designer/status-model",
    "workflow-designer/backbone"
], function(
    StatusModel,
    Backbone
) {
    /**
     * A collection of {@link JIRA.WorkflowDesigner.StatusModel}s.
     *
     * @class JIRA.WorkflowDesigner.StatusCollection
     * @extends Backbone.Collection
     */
    return Backbone.Collection.extend(
    /** @lends JIRA.WorkflowDesigner.StatusCollection# */
    {
        /**
         * The model class that the collection contains
         *
         * @param {object} attributes
         * @param {object} options
         * @returns {JIRA.WorkflowDesigner.StatusModel}
         */
        model: function (attributes, options) {
            return new StatusModel(attributes, options);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.StatusCollection", null, require("workflow-designer/status-collection"));