define("workflow-designer/browser-support", [
    "jira/util/navigator"
], function(
    navigator
) {
    /**
     * @returns {boolean} Whether the current browser is capable of running
     *     the workflow designer.
     */
    return {
        browserIsSupported: function browserIsSupported() {
            return !(navigator.isIE() && parseInt(navigator.majorVersion(), 10) < 10);
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.browserIsSupported", null, require("workflow-designer/browser-support").browserIsSupported);