AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var A;var D;var E;var C;var B;var J;var G;var I;var F=require("workflow-designer/test-utilities");var H=require("jquery");module("Application",{setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.canvas=F.testCanvas();var K=require("workflow-designer/io/ajax/workflow-ajax-manager");this.loadWorkflowStub=this.sandbox.stub(K,"load");this.publishStub=this.sandbox.stub(K,"publish");this.discardStub=this.sandbox.stub(K,"discard");this.mauStub=this.sandbox.stub(K,"triggerMauEventForProject");this.context.mock("workflow-designer/io/ajax/workflow-ajax-manager",K);C=this.context.require("workflow-designer/io/ajax/workflow-ajax-manager");this.context.mock("workflow-designer/browser-support",require("workflow-designer/browser-support"));G=this.context.require("workflow-designer/browser-support");this.context.mock("workflow-designer/io/layout-auto-saver",require("workflow-designer/io/layout-auto-saver"));J=this.context.require("workflow-designer/io/layout-auto-saver");var M=require("workflow-designer/workflow-model");this.workflowModelResetSpy=this.sandbox.spy(M.prototype,"reset");var L=new M();this.context.mock("workflow-designer/workflow-model",sinon.stub().returns(L));this.context.mock("workflow-designer/canvas",sinon.stub().returns(this.canvas));this.context.mock("workflow-designer/templates",require("workflow-designer/templates"));I=this.context.require("workflow-designer/templates");this.context.mock("workflow-designer/messages",require("workflow-designer/messages"));B=this.context.require("workflow-designer/messages");E=this.context.require("workflow-designer/workflow-model");D=this.context.require("workflow-designer/canvas")},prepareApplication:function(){A=this.context.require("workflow-designer/application")},teardown:function(){this.sandbox.restore()}});test("A global message is shown on error",function(){var L="No!",K=this.sandbox.stub(B,"showErrorMessage");this.prepareApplication();this.loadWorkflowStub.returns(H.Deferred().reject(L));new A({workflowId:"Workflow"});equal(K.callCount,1,"Messages.showErrorMessage was called");deepEqual(K.args[0],[L],"It was passed the correct arguments")});test("A warning is shown in unsupported browsers",function(){var L=H("#qunit-fixture"),K=this.sandbox.stub(G,"browserIsSupported").returns(false),M=this.sandbox.spy(I,"browserNotSupportedWarning");this.prepareApplication();new A({element:L});equal(D.callCount,0,"No Canvas was created");equal(K.callCount,1,"BrowserSupport.browserIsSupported was called");equal(M.callCount,1,"JIRA.WorkflowDesigner.Templates.browserNotSupportWarning was called");equal(L.find(".aui-message.warning").length,1,"The warning was appended to the application's element")});test("destroy() calls LayoutAutoSaver#destroy",function(){this.prepareApplication();var K=this.sandbox.spy(J.prototype,"destroy");new A().destroy();equal(K.callCount,1,"LayoutAutoSaver#destroy was called")});test("destroy() doesn't throw an exception in unsupported browsers",function(){this.prepareApplication();var K;expect(0);this.sandbox.stub(G,"browserIsSupported").returns(false);K=new A({element:H("#qunit-fixture")});K.destroy()});test("Passing layout data to the constructor",function(){this.prepareApplication();new A({layoutData:{}});equal(this.workflowModelResetSpy.callCount,1,"The Application's WorkflowModel was reset")});test("Supports loading a workflow by ID",function(){var K=H.Deferred();var L=E();sinon.spy(this.canvas,"autoFit");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.loadWorkflowStub.returns(K.promise());this.prepareApplication();new A({workflowId:"Workflow"});equal(this.loadWorkflowStub.callCount,1,"WorkflowAJAXManager#load() was called");deepEqual(this.loadWorkflowStub.args[0],["Workflow",false],"It was passed the correct arguments");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");K.resolve({});equal(this.canvas.autoFit.callCount,1,"Canvas#autoFit() was called");equal(this.canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(this.mauStub.callCount,1,"WorkflowAJAXManager#triggerMauEventForProject() was called");equal(this.workflowModelResetSpy.callCount,1,"WorkflowModel#reset() was called");deepEqual(this.workflowModelResetSpy.args[0],[{}],"It was passed the correct arguments");ok(L.has("loadedAt"),"WorkflowModel's loadedAt property was set");ok(L.get("loadedAt") instanceof Date,"It is a Date object");ok(new Date()-L.get("loadedAt")<500,"It is the current time")});test("The current step ID, if given, is passed to WorkflowModel",function(){this.prepareApplication();this.workflowModelSpy=E;new A({currentStepId:42});equal(this.workflowModelSpy.args[0][0].currentStepId,42,"The current step ID was passed to the WorkflowModel constructor")});test('Triggers a "loaded" event after successfully loading a workflow via AJAX',function(){this.prepareApplication();var L,K=H.Deferred(),M=sinon.spy();this.loadWorkflowStub.returns(K.promise());L=new A({workflowId:"Workflow"});L.on("loaded",M);K.resolve({});equal(M.callCount,1,'A "loaded" event was triggered')});test('Triggers a "loaded" event after successfully loading the given workflow data',function(){this.prepareApplication();var K=this.sandbox.spy(A.prototype,"trigger");new A({layoutData:{}});ok(K.calledWithExactly("loaded"),'A "loaded" event was triggered')});test("publishDraft() successfully publishes draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow"}),N,K=H.Deferred(),O=H.Deferred().resolve(),L=this.sandbox.stub(B,"showErrorMessage"),P=this.sandbox.stub(A.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.publishStub.returns(K.promise());P.returns(O);N=M.publishDraft();equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(N.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");K.resolve();equal(N.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(L.callCount,0,"Messages.showErrorMessage was not called");equal(P.callCount,1,"Workflow designer was reloaded")});test("publishDraft() without reloadDesigner flag successfully publishes draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow"}),N,K=H.Deferred(),L=this.sandbox.stub(B,"showErrorMessage"),O=this.sandbox.stub(A.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.publishStub.returns(K.promise());N=M.publishDraft({reloadDesigner:false});equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(N.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");K.resolve();equal(N.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(L.callCount,0,"Messages.showErrorMessage was not called");equal(O.callCount,0,"Workflow designer was not reloaded")});test("publishDraft() fails publishing draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow"}),N,K=H.Deferred(),L=this.sandbox.stub(B,"showErrorMessage");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.publishStub.returns(K.promise());N=M.publishDraft();equal(N.state(),"pending","The returned deferred is pending");equal(this.publishStub.callCount,1,"WorkflowAJAXManager#publish() was called");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");K.reject("error message");equal(N.state(),"rejected","The returned deferred is rejected on failure");equal(this.canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(L.callCount,1,"Messages.showErrorMessage was called")});test("discardDraft() successfully discards draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow"}),N,K=H.Deferred(),L=this.sandbox.stub(B,"showErrorMessage"),O=this.sandbox.stub(A.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.discardStub.returns(K.promise());O.returns(H.Deferred().resolve());N=M.discardDraft();equal(N.state(),"pending","The returned deferred is pending");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");K.resolve();equal(N.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(L.callCount,0,"Messages.showErrorMessage was not called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");equal(O.callCount,1,"Workflow designer was reloaded")});test("discardDraft() without reloadDesigner flag successfully discards draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow"}),N,K=H.Deferred(),L=this.sandbox.stub(B,"showErrorMessage"),O=this.sandbox.stub(A.prototype,"_loadWorkflow");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.discardStub.returns(K.promise());O.returns(H.Deferred().resolve());N=M.discardDraft({reloadDesigner:false});equal(N.state(),"pending","The returned deferred is pending");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");equal(this.discardStub.callCount,1,"WorkflowAJAXManager#discard() was called");K.resolve();equal(N.state(),"resolved","The returned deferred is resolved on success");equal(this.canvas.hideProgressIndicator.callCount,0,"Canvas#hideProgressIndicator() was not called");equal(L.callCount,0,"Messages.showErrorMessage was not called");equal(O.callCount,0,"Workflow designer was not reloaded")});test("discardDraft() fails discarding draft",function(){this.prepareApplication();var M=new A({workflowId:"Workflow"}),N,K=H.Deferred(),L=this.sandbox.stub(B,"showErrorMessage");sinon.spy(this.canvas,"hideProgressIndicator");sinon.spy(this.canvas,"showProgressIndicator");this.discardStub.returns(K.promise());N=M.discardDraft();equal(N.state(),"pending","The returned deferred is pending");equal(this.canvas.showProgressIndicator.callCount,1,"Canvas#showProgressIndicator() was called");K.reject("error message");equal(N.state(),"rejected","The returned deferred is rejected on failure");equal(this.canvas.hideProgressIndicator.callCount,1,"Canvas#hideProgressIndicator() was called");equal(L.callCount,1,"Messages.showErrorMessage was called")})});