/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.manager;

import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializationException;
import com.atlassian.jira.plugins.workflowdesigner.layout.LayoutSerializer;
import com.atlassian.jira.plugins.workflowdesigner.layout.LegacyLayoutSerializer;
import com.atlassian.jira.plugins.workflowdesigner.layout.PredefinedLayouts;
import com.atlassian.jira.plugins.workflowdesigner.layout.WorkflowLayoutGenerator;
import com.atlassian.jira.plugins.workflowdesigner.layout.display.DisplayLayout;
import com.atlassian.jira.plugins.workflowdesigner.layout.stored.StoredLayout;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.workflows.layout.persistence.WorkflowLayoutPropertyKeyBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import com.sysbliss.jira.plugins.workflow.util.WorkflowDesignerPropertySet;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class WorkflowLayoutManagerImpl
implements WorkflowLayoutManager {
    private final WorkflowDesignerPropertySet workflowDesignerPropertySet;
    private final LayoutSerializer layoutSerializer;
    private final LegacyLayoutSerializer legacyLayoutSerializer;
    private final PredefinedLayouts predefinedLayouts;
    private final WorkflowLayoutGenerator workflowLayoutGenerator;
    private final Workflows workflows;

    @Autowired
    public WorkflowLayoutManagerImpl(WorkflowDesignerPropertySet workflowDesignerPropertySet, LayoutSerializer layoutSerializer, LegacyLayoutSerializer legacyLayoutSerializer, PredefinedLayouts predefinedLayouts, WorkflowLayoutGenerator workflowLayoutGenerator, Workflows workflows) {
        this.workflowDesignerPropertySet = workflowDesignerPropertySet;
        this.layoutSerializer = layoutSerializer;
        this.legacyLayoutSerializer = legacyLayoutSerializer;
        this.predefinedLayouts = predefinedLayouts;
        this.workflowLayoutGenerator = workflowLayoutGenerator;
        this.workflows = workflows;
    }

    @Override
    public DisplayLayout getLayout(boolean isDraft, String workflowName) throws LayoutSerializationException {
        Workflow workflow = this.workflows.getWorkflow(isDraft, workflowName);
        return workflow.isDefault() ? this.getDefaultLayout(workflow) : this.generateLayout(workflow);
    }

    private DisplayLayout getDefaultLayout(Workflow workflow) throws LayoutSerializationException {
        StoredLayout predefinedLayout = this.parsePredefinedDefaultLayout();
        return this.workflowLayoutGenerator.generate(predefinedLayout, workflow);
    }

    private StoredLayout parsePredefinedDefaultLayout() throws LayoutSerializationException {
        String layoutJson = this.predefinedLayouts.defaultWorkflow();
        return this.layoutSerializer.deserializeFromJson(layoutJson);
    }

    private DisplayLayout generateLayout(Workflow workflow) throws LayoutSerializationException {
        StoredLayout existingLayout = this.getLayout(workflow);
        if (existingLayout == null) {
            existingLayout = this.getLegacyLayout(workflow);
        }
        return this.workflowLayoutGenerator.generate(existingLayout, workflow);
    }

    private StoredLayout getLayout(Workflow workflow) throws LayoutSerializationException {
        String json = this.getLayoutJson(workflow.isDraftWorkflow(), workflow.getName());
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        return this.layoutSerializer.deserializeFromJson(json);
    }

    private StoredLayout getLegacyLayout(Workflow workflow) throws LayoutSerializationException {
        return this.getLegacyLayout(workflow.isDraftWorkflow(), workflow.getName());
    }

    private StoredLayout getLegacyLayout(boolean draft, String workflowName) throws LayoutSerializationException {
        String legacyLayoutKey = this.getWorkflowPropertyKey(draft, workflowName, false);
        if (!this.workflowDesignerPropertySet.hasProperty(legacyLayoutKey)) {
            return null;
        }
        String legacyLayoutJson = this.workflowDesignerPropertySet.getProperty(legacyLayoutKey);
        return this.legacyLayoutSerializer.parse(legacyLayoutJson);
    }

    @Override
    public void saveLayout(Workflow workflow, StoredLayout layout) throws LayoutSerializationException {
        this.saveLayout(workflow.isDraftWorkflow(), workflow.getName(), layout);
    }

    private void saveLayout(boolean draft, String workflowName, StoredLayout layout) throws LayoutSerializationException {
        String propertyKey = this.getWorkflowPropertyKey(draft, workflowName);
        String json = this.layoutSerializer.serializeToJson(layout);
        this.workflowDesignerPropertySet.setProperty(propertyKey, json);
    }

    @Override
    public void copyLayoutForDraftWorkflow(String workflowName) throws LayoutSerializationException {
        StoredLayout legacyLayout;
        if (!this.copyLayoutBetweenModes(false, true, workflowName) && (legacyLayout = this.getLegacyLayout(false, workflowName)) != null) {
            this.saveLayout(true, workflowName, legacyLayout);
        }
    }

    @Override
    public void publishDraftLayout(String workflowName) {
        this.copyLayoutBetweenModes(true, false, workflowName);
    }

    private boolean copyLayoutBetweenModes(boolean fromMode, boolean toMode, String workflowName) {
        String json = this.getLayoutJson(fromMode, workflowName);
        if (StringUtils.isNotBlank((String)json)) {
            String toKey = this.getWorkflowPropertyKey(toMode, workflowName);
            this.workflowDesignerPropertySet.setProperty(toKey, json);
            return true;
        }
        return false;
    }

    @Override
    public void removeDraftLayout(String workflowName) {
        this.removeLayout(true, workflowName);
    }

    @Override
    public void removeActiveLayout(String workflowName) {
        this.removeLayout(false, workflowName);
    }

    protected void removeLayout(boolean isDraft, String workflowName) {
        String propKey = this.getWorkflowPropertyKey(isDraft, workflowName, true);
        String legacyPropKey = this.getWorkflowPropertyKey(isDraft, workflowName, false);
        if (this.workflowDesignerPropertySet.hasProperty(propKey)) {
            this.workflowDesignerPropertySet.removeProperty(propKey);
        }
        if (this.workflowDesignerPropertySet.hasProperty(legacyPropKey)) {
            this.workflowDesignerPropertySet.removeProperty(legacyPropKey);
        }
    }

    @Override
    public void copyActiveLayout(String sourceWorkflowName, String targetWorkflowName) {
        String json = this.getActiveLayout(sourceWorkflowName);
        if (StringUtils.isNotBlank((String)json)) {
            String toKey = this.getWorkflowPropertyKey(false, targetWorkflowName);
            this.workflowDesignerPropertySet.setProperty(toKey, json);
        }
    }

    private String getActiveLayout(String workflowName) {
        Workflow workflow = this.workflows.getWorkflow(false, workflowName);
        if (workflow != null && workflow.isDefault()) {
            return this.predefinedLayouts.defaultWorkflow();
        }
        return this.getLayoutJson(false, workflowName);
    }

    @Override
    public void moveActiveLayout(String sourceWorkflowName, String targetWorkflowName) {
        String sourceKey = this.getWorkflowPropertyKey(false, sourceWorkflowName);
        if (this.workflowDesignerPropertySet.hasProperty(sourceKey)) {
            String layout = this.workflowDesignerPropertySet.getProperty(sourceKey);
            String targetKey = this.getWorkflowPropertyKey(false, targetWorkflowName);
            this.workflowDesignerPropertySet.setProperty(targetKey, layout);
            this.workflowDesignerPropertySet.removeProperty(sourceKey);
        }
    }

    private String getLayoutJson(boolean isDraft, String workflowName) {
        String propertyKey = this.getWorkflowPropertyKey(isDraft, workflowName, true);
        return this.workflowDesignerPropertySet.getProperty(propertyKey);
    }

    private String getWorkflowPropertyKey(boolean isDraft, String workflowName) {
        return this.getWorkflowPropertyKey(isDraft, workflowName, true);
    }

    private String getWorkflowPropertyKey(boolean isDraft, String workflowName, boolean version2) {
        WorkflowLayoutPropertyKeyBuilder.WorkflowState state = isDraft ? WorkflowLayoutPropertyKeyBuilder.WorkflowState.DRAFT : WorkflowLayoutPropertyKeyBuilder.WorkflowState.LIVE;
        return WorkflowLayoutPropertyKeyBuilder.newBuilder().setWorkflowName(workflowName).setWorkflowState(state).setVersion2(version2).build();
    }
}

