/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.DraftWorkflowCreatedEvent;
import com.atlassian.jira.event.DraftWorkflowPublishedEvent;
import com.atlassian.jira.event.WorkflowCopiedEvent;
import com.atlassian.jira.event.WorkflowDeletedEvent;
import com.atlassian.jira.event.WorkflowRenamedEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.sysbliss.jira.plugins.workflow.event.WorkflowLayoutHousekeeper;
import com.sysbliss.jira.plugins.workflow.manager.WorkflowLayoutManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={WorkflowLayoutHousekeeper.class, LifecycleAware.class})
@Component
public class WorkflowLayoutHousekeeperImpl
implements WorkflowLayoutHousekeeper,
LifecycleAware,
DisposableBean {
    public static Logger log = Logger.getLogger(WorkflowLayoutHousekeeperImpl.class);
    private final EventPublisher eventPublisher;
    private final WorkflowLayoutManager workflowLayoutManager;

    @Autowired
    public WorkflowLayoutHousekeeperImpl(EventPublisher eventPublisher, WorkflowLayoutManager workflowLayoutManager) {
        this.eventPublisher = eventPublisher;
        this.workflowLayoutManager = workflowLayoutManager;
    }

    @EventListener
    public void onDraftWorkflowCreated(DraftWorkflowCreatedEvent event) throws Exception {
        this.workflowLayoutManager.copyLayoutForDraftWorkflow(event.getWorkflow().getName());
    }

    @EventListener
    public void onDraftWorkflowPublished(DraftWorkflowPublishedEvent event) throws Exception {
        this.workflowLayoutManager.publishDraftLayout(event.getWorkflow().getName());
    }

    @EventListener
    public void onWorkflowCopied(WorkflowCopiedEvent event) throws Exception {
        this.workflowLayoutManager.copyActiveLayout(event.getOriginalWorkflow().getName(), event.getNewWorkflow().getName());
    }

    @EventListener
    public void onWorkflowDeleted(WorkflowDeletedEvent event) {
        this.workflowLayoutManager.removeActiveLayout(event.getWorkflow().getName());
    }

    @EventListener
    public void onDraftWorkflowDeleted(WorkflowDeletedEvent event) {
        this.workflowLayoutManager.removeDraftLayout(event.getWorkflow().getName());
    }

    @EventListener
    public void onWorkflowRenamed(WorkflowRenamedEvent event) {
        try {
            String oldName = event.getOldWorkflowName();
            String newName = event.getNewWorkflowName();
            this.workflowLayoutManager.moveActiveLayout(oldName, newName);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while handling workflow renaming", (Throwable)e);
        }
    }

    public void onStart() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

