/*
 * Decompiled with CFR 0.152.
 */
package com.sysbliss.jira.plugins.workflow.auth;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.sysbliss.jira.plugins.workflow.auth.UserTokenManager;
import com.sysbliss.jira.plugins.workflow.util.TokenMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SecureUserTokenManager
implements UserTokenManager {
    public static long DEFAULT_TIMEOUT = 1L * DateUtils.HOUR_MILLIS;
    private final Map<String, String> tokensToUsers;
    private final Map<String, String> usersToTokens;
    private final TokenFactory tokenFactory;
    private final UserManager userManager;

    @Autowired
    public SecureUserTokenManager(UserManager userManager) {
        this.userManager = userManager;
        this.tokensToUsers = new TokenMap<String, String>(DEFAULT_TIMEOUT);
        this.usersToTokens = new HashMap<String, String>();
        this.tokenFactory = new TokenFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationUser getUserFromToken(String token) {
        Map<String, String> map = this.tokensToUsers;
        synchronized (map) {
            String userKey = this.tokensToUsers.get(token);
            ApplicationUser user = this.userManager.getUserByKey(userKey);
            if (user != null) {
                this.tokensToUsers.put(token, userKey);
                this.usersToTokens.put(userKey, token);
            }
            return user;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findToken(ApplicationUser user) {
        String token = null;
        if (user != null) {
            Map<String, String> map = this.tokensToUsers;
            synchronized (map) {
                token = this.usersToTokens.get(user);
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createToken(ApplicationUser user) throws Exception {
        String token = this.findToken(user);
        if (token == null) {
            Map<String, String> map = this.tokensToUsers;
            synchronized (map) {
                token = this.tokenFactory.createToken();
                this.tokensToUsers.put(token, user.getKey());
                this.usersToTokens.put(user.getKey(), token);
            }
        }
        return token;
    }

    public static class TokenFactory {
        public String createToken() {
            return DefaultSecureTokenGenerator.getInstance().generateToken();
        }
    }
}

