/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.workflow.WorkflowService;
import com.atlassian.jira.plugins.workflowdesigner.utilities.ScreenNameResolver;
import com.atlassian.jira.plugins.workflowdesigner.utilities.UserProjectWorkflowUtilities;
import com.atlassian.jira.plugins.workflowdesigner.utilities.WorkflowFunctionUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionOptions;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Workflows {
    private static final Logger LOG = Logger.getLogger(Workflows.class);
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserProjectWorkflowUtilities userProjectWorkflowUtilities;
    private final WorkflowFunctionUtilities workflowFunctionUtilities;
    private final WorkflowManager workflowManager;
    private final WorkflowService workflowService;
    private final TransitionOptions transitionOptions;
    private final ScreenNameResolver screenNameResolver;

    @Autowired
    public Workflows(JiraAuthenticationContext jiraAuthenticationContext, UserProjectWorkflowUtilities userProjectWorkflowUtilities, WorkflowFunctionUtilities workflowFunctionUtilities, WorkflowManager workflowManager, WorkflowService workflowService, TransitionOptions transitionOptions, ScreenNameResolver screenNameResolver) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userProjectWorkflowUtilities = userProjectWorkflowUtilities;
        this.workflowFunctionUtilities = workflowFunctionUtilities;
        this.workflowManager = workflowManager;
        this.workflowService = workflowService;
        this.transitionOptions = transitionOptions;
        this.screenNameResolver = screenNameResolver;
    }

    public ServiceOutcome<Workflow> getMutableWorkflow(String workflowName) {
        if ("jira".equals(workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.rest.resource.workflow.not_editable", new Object[0]);
        }
        ApplicationUser user = this.getCurrentUser();
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(user, workflowName)) {
            return Outcomes.errorOutcome(user != null ? "workflow.designer.forbidden" : "workflow.designer.workflow.doesnt.exist.not.authenticated", new Object[0]);
        }
        Workflow workflow = this.getOrCreateMutableWorkflow(this.createServiceContext(), workflowName);
        if (workflow == null) {
            return Outcomes.errorOutcome("workflow.designer.workflow.doesnt.exist", new Object[0]);
        }
        return ServiceOutcomeImpl.ok((Object)workflow);
    }

    public Workflow getMutableWorkflowWithoutValidation(String workflowName) {
        return this.getOrCreateMutableWorkflow(this.createServiceContext(), workflowName);
    }

    public ServiceOutcome<Workflow> saveWorkflow(Workflow workflow) {
        return this.saveWorkflow(workflow, workflow);
    }

    public ServiceOutcome<Void> discardDraft(String workflowName) {
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.rest.resource.workflow.invalid_name", new Object[0]);
        }
        JiraServiceContext serviceContext = this.createServiceContext();
        this.workflowService.deleteDraftWorkflow(serviceContext, workflowName);
        return ServiceOutcomeImpl.ok(null);
    }

    public Workflow getWorkflow(boolean isDraft, String workflowName) {
        JiraServiceContext serviceContext = this.createServiceContext();
        JiraWorkflow jiraWorkflow = this.workflowService.getWorkflow(serviceContext, workflowName);
        if (isDraft && jiraWorkflow != null && jiraWorkflow.isActive()) {
            jiraWorkflow = this.getOrCreateDraftWorkflow(serviceContext, workflowName);
        }
        return this.getWorkflow(jiraWorkflow);
    }

    public Workflow getDraftWorkflow(String workflowName) {
        JiraServiceContext serviceContext = this.createServiceContext();
        JiraWorkflow jiraWorkflow = this.workflowService.getDraftWorkflow(serviceContext, workflowName);
        return this.getWorkflow(jiraWorkflow);
    }

    private Workflow getWorkflow(JiraWorkflow jiraWorkflow) {
        return jiraWorkflow != null ? new Workflow(jiraWorkflow, this.workflowFunctionUtilities, this.workflowService, this.jiraAuthenticationContext, this.transitionOptions, this.screenNameResolver) : null;
    }

    public boolean workflowExists(boolean isDraft, String workflowName) {
        return this.getWorkflow(isDraft, workflowName) != null;
    }

    public boolean workflowIsEditable(boolean isDraft, String workflowName) {
        Workflow workflow = this.getWorkflow(isDraft, workflowName);
        return workflow != null && workflow.isEditable();
    }

    public ServiceOutcome<Workflow> publishDraft(String parentWorkflowName) {
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), parentWorkflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        JiraServiceContext serviceContext = this.createServiceContext();
        this.workflowService.overwriteActiveWorkflow(serviceContext, parentWorkflowName);
        ErrorCollection errorCollection = serviceContext.getErrorCollection();
        if (errorCollection.hasAnyErrors()) {
            return Outcomes.errorOutcome(errorCollection);
        }
        return ServiceOutcomeImpl.ok((Object)this.getWorkflow(false, parentWorkflowName));
    }

    public Workflow getClone(String workflowName) {
        JiraWorkflow jiraWorkflow = this.workflowManager.getWorkflowClone(workflowName);
        return this.getWorkflow(jiraWorkflow);
    }

    private Workflow getOrCreateMutableWorkflow(JiraServiceContext serviceContext, String workflowName) {
        JiraWorkflow jiraWorkflow;
        JiraWorkflow workflow = this.workflowService.getWorkflow(serviceContext, workflowName);
        if (workflow == null) {
            return null;
        }
        if (workflow.isActive()) {
            jiraWorkflow = this.getOrCreateDraftWorkflow(serviceContext, workflowName);
            if (jiraWorkflow == null) {
                jiraWorkflow = workflow;
            }
        } else {
            jiraWorkflow = this.workflowManager.getWorkflowClone(workflowName);
        }
        return this.getWorkflow(jiraWorkflow);
    }

    private <T> ServiceOutcome<T> saveWorkflow(T value, JiraWorkflow workflow) {
        ErrorCollection saveWorkflowErrors;
        try {
            JiraServiceContext serviceContext = this.createServiceContext();
            this.workflowService.updateWorkflow(serviceContext, workflow);
            saveWorkflowErrors = serviceContext.getErrorCollection();
        }
        catch (Exception e) {
            LOG.error((Object)"saveWorkflow - exception occurred saving workflow", (Throwable)e);
            SimpleErrorCollection errorCollection = new SimpleErrorCollection();
            errorCollection.addErrorMessage(this.getText("workflow.designer.saving.workflow.failed", new Object[0]));
            saveWorkflowErrors = errorCollection;
        }
        if (saveWorkflowErrors.hasAnyErrors()) {
            return Outcomes.errorOutcome(saveWorkflowErrors);
        }
        return ServiceOutcomeImpl.ok(value);
    }

    private JiraWorkflow getOrCreateDraftWorkflow(JiraServiceContext serviceContext, String workflowName) {
        JiraWorkflow workflow = this.workflowService.getDraftWorkflow(serviceContext, workflowName);
        if (workflow == null) {
            workflow = this.workflowService.createDraftWorkflow(serviceContext, workflowName);
        }
        return workflow;
    }

    private JiraServiceContext createServiceContext() {
        return new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser());
    }

    private ApplicationUser getCurrentUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }

    private String getText(String messageKey, Object ... arguments) {
        return this.jiraAuthenticationContext.getI18nHelper().getText(messageKey, (Object)arguments);
    }
}

