/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.plugins.workflowdesigner.utilities.UserProjectWorkflowUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.security.JiraAuthenticationContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowLoopedTransitions {
    private final Workflows workflows;
    private final FieldScreenManager fieldScreenManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserProjectWorkflowUtilities userProjectWorkflowUtilities;

    @Autowired
    public WorkflowLoopedTransitions(Workflows workflows, FieldScreenManager fieldScreenManager, JiraAuthenticationContext jiraAuthenticationContext, UserProjectWorkflowUtilities userProjectWorkflowUtilities) {
        this.workflows = workflows;
        this.fieldScreenManager = fieldScreenManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userProjectWorkflowUtilities = userProjectWorkflowUtilities;
    }

    public ServiceOutcome<TransitionData> createLoopedTransition(String loopedTransitionName, String loopedTransitionDescription, Long screenId, String workflowName) {
        FieldScreen screen;
        ServiceOutcome<Workflow> verificationResult = this.verifyLoopedTransitionCanBeAdded(loopedTransitionName, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return Outcomes.errorOutcome(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<TransitionData> transitionAdded = workflow.addLoopedTransition(loopedTransitionName, loopedTransitionDescription, screen = this.screenIdSet(screenId) ? this.fieldScreenManager.getFieldScreen(screenId) : null);
        if (transitionAdded.isValid()) {
            this.workflows.saveWorkflow(workflow);
        }
        return transitionAdded;
    }

    public ServiceOutcome<Workflow> deleteLoopedTransition(int loopedTransitionId, String workflowName) {
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteLoopedTransition(loopedTransitionId);
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> updateLoopedTransition(int transitionId, String name, String description, Long screenId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyLoopedTransitionCanBeUpdated(transitionId, name, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateLoopedTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow((Workflow)updateOutcome.getReturnedValue());
    }

    private ServiceOutcome<Workflow> verifyLoopedTransitionCanBeAdded(String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (workflow.isDuplicateLoopedTransitionName(name)) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    public ServiceOutcome<Workflow> verifyLoopedTransitionCanBeUpdated(int transitionId, String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return Outcomes.errorOutcome("workflow.designer.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && workflow.isDuplicateLoopedTransitionName(name)) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }
}

