/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugins.workflowdesigner.utilities.UserProjectWorkflowUtilities;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Outcomes;
import com.atlassian.jira.plugins.workflowdesigner.workflow.TransitionData;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflow;
import com.atlassian.jira.plugins.workflowdesigner.workflow.Workflows;
import com.atlassian.jira.security.JiraAuthenticationContext;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowGlobalTransitions {
    private static final Pattern GENERATED_GLOBAL_TRANSITION_NAME_PATTERN = Pattern.compile("(.*)\\(([0-9]+)\\)$");
    private final Workflows workflows;
    private final StatusManager statusManager;
    private final FieldScreenManager fieldScreenManager;
    private final UserProjectWorkflowUtilities userProjectWorkflowUtilities;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public WorkflowGlobalTransitions(StatusManager statusManager, Workflows workflows, FieldScreenManager fieldScreenManager, UserProjectWorkflowUtilities userProjectWorkflowUtilities, JiraAuthenticationContext jiraAuthenticationContext) {
        this.workflows = workflows;
        this.statusManager = statusManager;
        this.fieldScreenManager = fieldScreenManager;
        this.userProjectWorkflowUtilities = userProjectWorkflowUtilities;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public ServiceOutcome<Workflow> createGlobalTransition(String statusId, String workflowName, String globalTransitionName, String globalTransitionDescription, Long screenId) {
        Status status = this.statusManager.getStatus(statusId);
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeAdded(globalTransitionName, status, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.addGlobalTransition(globalTransitionName = this.resolveUniqueGlobalTransitionName(workflow, globalTransitionName), globalTransitionDescription, status, this.fieldScreenManager.getFieldScreen(screenId));
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<TransitionData> addGlobalTransitionToWorkflow(String workflowName, String statusId, String globalTransitionName, String globalTransitionDescription, Long screenId) {
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeAdded(globalTransitionName, this.statusManager.getStatus(statusId), workflowName, screenId);
        if (!verificationResult.isValid()) {
            return Outcomes.errorOutcome(verificationResult.getErrorCollection());
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<TransitionData> transitionAdded = workflow.addGlobalTransition(globalTransitionName = this.resolveUniqueGlobalTransitionName(workflow, globalTransitionName), globalTransitionDescription, statusId, this.fieldScreenManager.getFieldScreen(screenId));
        if (transitionAdded.isValid()) {
            this.workflows.saveWorkflow(workflow);
        }
        return transitionAdded;
    }

    public ServiceOutcome<Workflow> deleteGlobalTransition(String globalTransitionId, String workflowName) {
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return workflowOutcome;
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        ServiceOutcome<Workflow> result = workflow.deleteGlobalTransition(globalTransitionId);
        if (!result.isValid()) {
            return result;
        }
        return this.workflows.saveWorkflow(workflow);
    }

    public ServiceOutcome<Workflow> updateGlobalTransition(int transitionId, String name, String description, Long screenId, String workflowName) {
        ServiceOutcome<Workflow> verificationResult = this.verifyGlobalTransitionCanBeUpdated(transitionId, name, workflowName, screenId);
        if (!verificationResult.isValid()) {
            return verificationResult;
        }
        Workflow workflow = (Workflow)verificationResult.getReturnedValue();
        ServiceOutcome<Workflow> updateOutcome = workflow.updateGlobalTransition(transitionId, name, description, this.fieldScreenManager.getFieldScreen(screenId));
        if (!updateOutcome.isValid()) {
            return updateOutcome;
        }
        return this.workflows.saveWorkflow((Workflow)updateOutcome.getReturnedValue());
    }

    private ServiceOutcome<Workflow> verifyGlobalTransitionCanBeAdded(String name, Status status, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        if (status == null) {
            return Outcomes.errorOutcome("workflow.designer.status.not.found", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.statusExistsOnWorkflow(status)) {
            return Outcomes.errorOutcome("workflow.designer.adding.global.transition.no.status", new Object[0]);
        }
        if (workflow.statusHasGlobalTransition(status)) {
            return Outcomes.errorOutcome("workflow.designer.adding.global.transition.duplicate", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    public ServiceOutcome<Workflow> verifyGlobalTransitionCanBeUpdated(int transitionId, String name, String workflowName, Long screenId) {
        FieldScreen fieldScreen;
        if (!this.userProjectWorkflowUtilities.userCanEditWorkflow(this.jiraAuthenticationContext.getLoggedInUser(), workflowName)) {
            return Outcomes.errorOutcome("workflow.designer.forbidden", new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            return Outcomes.errorOutcome("workflow.designer.enter.a.name", new Object[0]);
        }
        ServiceOutcome<Workflow> workflowOutcome = this.workflows.getMutableWorkflow(workflowName);
        if (!workflowOutcome.isValid()) {
            return Outcomes.errorOutcome(workflowOutcome.getErrorCollection());
        }
        Workflow workflow = (Workflow)workflowOutcome.getReturnedValue();
        if (!workflow.hasTransition(transitionId)) {
            return Outcomes.errorOutcome("workflow.designer.updating.transition.not.found", new Object[0]);
        }
        if (!name.equals(workflow.getTransitionName(transitionId)) && (workflow.isDuplicateGlobalTransitionName(name) || workflow.targetStatusHasExistingTransitionWithName(transitionId, name))) {
            return Outcomes.errorOutcome("workflow.designer.transition.name.exists", new Object[0]);
        }
        if (this.screenIdSet(screenId) && (fieldScreen = this.fieldScreenManager.getFieldScreen(screenId)) == null) {
            return Outcomes.errorOutcome("workflow.designer.transition.screen.not.found", new Object[0]);
        }
        return Outcomes.okOutcome(workflow);
    }

    private boolean screenIdSet(Long screenId) {
        return screenId != null && screenId != 0L;
    }

    private String nextGlobalTransitionName(@Nonnull String transitionName, @Nonnull Set<String> usedStrings) {
        String candidate;
        String baseCandidate = this.extractBaseTransitionName(transitionName);
        int i = 2;
        do {
            candidate = baseCandidate + "(" + i + ")";
            ++i;
        } while (usedStrings.contains(candidate));
        return candidate;
    }

    private String extractBaseTransitionName(String transitionName) {
        Matcher matcher = GENERATED_GLOBAL_TRANSITION_NAME_PATTERN.matcher(transitionName);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return transitionName + " ";
    }

    public String resolveUniqueGlobalTransitionName(Workflow workflow, String globalTransitionName) {
        Set<String> allTransitions = workflow.getDistinctTransitionNames();
        if (allTransitions.contains(globalTransitionName)) {
            return this.nextGlobalTransitionName(globalTransitionName, allTransitions);
        }
        return globalTransitionName;
    }
}

