/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.workflow;

import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageReplaceHelper {
    private final FeatureManager featureManager;
    private final Map<String, String> replaceMap = ImmutableMap.of((Object)"workflow.designer.forbidden", (Object)"workflow.designer.workflow.doesnt.exist");
    private static final FeatureFlag PROJECT_LEVEL_ADMIN_PERMISSIONS_DARK_FEATURE = FeatureFlag.featureFlag((String)"com.atlassian.jira.permission-schemes.project-level-admin");

    @Autowired
    public MessageReplaceHelper(@ComponentImport FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public String replace(String messageKey) {
        if (messageKey != null && this.replaceMap.containsKey(messageKey)) {
            if (!this.featureManager.isEnabled(PROJECT_LEVEL_ADMIN_PERMISSIONS_DARK_FEATURE)) {
                return this.replaceMap.get(messageKey);
            }
            return messageKey;
        }
        return messageKey;
    }
}

