/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.workflowdesigner.validation.validators;

import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Edge;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Node;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.Transition;
import com.atlassian.jira.plugins.workflowdesigner.validation.api.graph.WorkflowGraph;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

final class WorkflowGraphAnalyzer {
    private final WorkflowGraph workflowGraph;

    public WorkflowGraphAnalyzer(WorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public Iterable<Node> unreachableNodes() {
        Set<Node> nodesReachableFromRoot = WorkflowGraphAnalyzer.reachableNodes(this.workflowGraph.getRoot(), Sets.newHashSet());
        return Sets.difference(this.workflowGraph.getAllNodes(), nodesReachableFromRoot);
    }

    public Iterable<Edge> edgesFromUnreachableStates() {
        Set<Node> nodesReachableFromRoot = WorkflowGraphAnalyzer.reachableNodes(this.workflowGraph.getRoot(), Sets.newHashSet());
        Sets.SetView nodesUnreachable = Sets.difference(this.workflowGraph.getAllNodes(), nodesReachableFromRoot);
        return Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)nodesUnreachable, (Function)new Function<Node, Iterable<Edge>>(){

            public Iterable<Edge> apply(Node node) {
                return node.getEdges();
            }
        })), (Predicate)new Predicate<Edge>(){

            public boolean apply(Edge edge) {
                return edge.getTransition().getType() == Transition.Type.REGULAR;
            }
        });
    }

    public Iterable<Node> deadEndNodes() {
        return Iterables.filter(this.workflowGraph.getAllNodes(), (Predicate)new Predicate<Node>(){

            public boolean apply(final Node node) {
                return Iterables.isEmpty((Iterable)Iterables.filter(node.getEdges(), (Predicate)new Predicate<Edge>(){

                    public boolean apply(Edge input) {
                        return !input.getDestination().equals(node);
                    }
                }));
            }
        });
    }

    public Iterable<Edge> edgesToDeadEndNodes() {
        final HashSet deadEndNodes = Sets.newHashSet(this.deadEndNodes());
        return Iterables.filter(this.workflowGraph.getAllEdges(), (Predicate)new Predicate<Edge>(){

            public boolean apply(Edge edge) {
                return deadEndNodes.contains(edge.getDestination());
            }
        });
    }

    private static Set<Node> reachableNodes(Node node, Set<Node> visited) {
        visited.add(node);
        for (Edge edge : node.getEdges()) {
            if (visited.contains(edge.getDestination())) continue;
            visited = WorkflowGraphAnalyzer.reachableNodes(edge.getDestination(), visited);
        }
        return visited;
    }
}

